/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.primitives.Ints;
import com.trivago.triava.tcache.Cache;
import com.trivago.triava.tcache.TCacheFactory;
import com.trivago.triava.tcache.eviction.EvictionInterface;
import com.trivago.triava.tcache.eviction.LFUEviction;
import com.trivago.triava.tcache.eviction.LRUEviction;
import com.typesafe.config.Config;
import java.util.Locale;

@Policy.PolicySpec(name="product.TCache")
public final class TCachePolicy
implements Policy.KeyOnlyPolicy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);

    public TCachePolicy(Config config) {
        TCacheSettings settings = new TCacheSettings(config);
        this.cache = TCacheFactory.standardFactory().builder().setMaxElements(Ints.checkedCast((long)settings.maximumSize())).setEvictionClass(settings.policy()).setStatistics(true).build();
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            this.policyStats.recordMiss();
            this.cache.put((Object)key, (Object)key);
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.cache.close();
        this.policyStats.addEvictions(this.cache.statistics().getEvictionCount());
    }

    static final class TCacheSettings
    extends BasicSettings {
        public TCacheSettings(Config config) {
            super(config);
        }

        public <K, V> EvictionInterface<K, V> policy() {
            String policy;
            switch (policy = this.config().getString("tcache.policy").toLowerCase(Locale.US)) {
                case "lfu": {
                    return new LFUEviction();
                }
                case "lru": {
                    return new LRUEviction();
                }
            }
            throw new IllegalArgumentException("Unknown policy type: " + policy);
        }
    }
}

