/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashFunctionParser;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashedItem;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinySetIndexing;
import java.util.Random;

public final class TinyCacheSketch {
    public final long[] chainIndex;
    public final long[] lastIndex;
    private final HashFunctionParser hashFunc;
    private final int itemsPerSet;
    private final byte[] cache;
    private final Random rnd;

    public TinyCacheSketch(int nrSets, int itemsPerSet, int randomSeed) {
        this.chainIndex = new long[nrSets];
        this.lastIndex = new long[nrSets];
        this.itemsPerSet = itemsPerSet;
        this.hashFunc = new HashFunctionParser(nrSets);
        this.cache = new byte[nrSets * itemsPerSet];
        this.rnd = new Random(randomSeed);
    }

    public int countItem(long item) {
        this.hashFunc.createHash(item);
        int $ = 0;
        if (!TinySetIndexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], this.hashFunc.fpaux.chainId)) {
            return 0;
        }
        TinySetIndexing.getChain(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        int offset = this.itemsPerSet * this.hashFunc.fpaux.set;
        TinySetIndexing.chainStart += offset;
        TinySetIndexing.chainEnd += offset;
        while (TinySetIndexing.chainStart <= TinySetIndexing.chainEnd) {
            try {
                $ += this.cache[TinySetIndexing.chainStart % this.cache.length] == this.hashFunc.fpaux.fingerprint ? 1 : 0;
                ++TinySetIndexing.chainStart;
            }
            catch (Exception e) {
                System.out.println(" length: " + this.cache.length + " Access: " + TinySetIndexing.chainStart);
            }
        }
        return $;
    }

    private int replace(HashedItem fpaux, byte victim, int bucketStart, int removedOffset) {
        byte chainId = fpaux.chainId;
        fpaux.chainId = victim;
        this.cache[bucketStart + removedOffset] = 0;
        TinySetIndexing.removeItem(fpaux, this.chainIndex, this.lastIndex);
        fpaux.chainId = chainId;
        int idxToAdd = TinySetIndexing.addItem(fpaux, this.chainIndex, this.lastIndex);
        int delta = removedOffset < idxToAdd ? -1 : 1;
        this.replaceItems(idxToAdd, fpaux.fingerprint, bucketStart, delta);
        return removedOffset;
    }

    public void addItem(long item) {
        this.hashFunc.createHash(item);
        int bucketStart = this.itemsPerSet * this.hashFunc.fpaux.set;
        if (this.cache[bucketStart + this.itemsPerSet - 1] != 0) {
            this.selectVictim(bucketStart);
            return;
        }
        int idxToAdd = TinySetIndexing.addItem(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        this.replaceItems(idxToAdd, this.hashFunc.fpaux.fingerprint, bucketStart, 1);
    }

    private void selectVictim(int bucketStart) {
        byte victimOffset = (byte)this.rnd.nextInt(this.itemsPerSet);
        int victimChain = TinySetIndexing.getChainAtOffset(this.hashFunc.fpaux, this.chainIndex, this.lastIndex, victimOffset);
        if (!TinySetIndexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], victimChain)) {
            throw new RuntimeException("Failed to replace");
        }
        this.replace(this.hashFunc.fpaux, (byte)victimChain, bucketStart, victimOffset);
    }

    private void replaceItems(int idx, byte value, int start, int delta) {
        start += idx;
        do {
            byte $ = this.cache[start];
            this.cache[start] = value;
            value = $;
            start += delta;
        } while (value != 0);
    }
}

