/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class FeedbackWindowTinyLfuPolicy
implements Policy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final TinyLfu admittor;
    private final int maximumSize;
    private final Node headWindow;
    private final Node headProbation;
    private final Node headProtected;
    private int maxWindow;
    private int maxProtected;
    private int sizeWindow;
    private int sizeProtected;
    private int pivot;
    private final int maxPivot;
    private final int pivotIncrement;
    private final int pivotDecrement;
    private int sample;
    private int sampled;
    private int adjusted;
    private final int sampleSize;
    private final Membership feedback;
    boolean debug;
    boolean trace;

    public FeedbackWindowTinyLfuPolicy(double percentMain, FeedbackWindowTinyLfuSettings settings) {
        String name = String.format("sketch.FeedbackWindowTinyLfu (%.0f%%)", 100.0 * (1.0 - percentMain));
        this.policyStats = new PolicyStats(name);
        this.admittor = new TinyLfu(settings.config(), this.policyStats);
        int maxMain = (int)((double)settings.maximumSize() * percentMain);
        this.maxProtected = (int)((double)maxMain * settings.percentMainProtected());
        this.maxWindow = Math.min(settings.maximumWindowSize(), settings.maximumSize() - maxMain);
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.headProtected = new Node();
        this.headProbation = new Node();
        this.headWindow = new Node();
        this.pivot = (int)(settings.percentPivot() * (double)this.maxWindow);
        this.maxPivot = Math.min(settings.maximumWindowSize(), this.maxProtected);
        this.sampleSize = Math.min(settings.maximumSampleSize(), this.maximumSize);
        this.feedback = settings.membershipFilter().create(this.sampleSize, settings.adaptiveFpp(), settings.config());
        Preconditions.checkState((settings.pivotIncrement() > 0 ? 1 : 0) != 0, (Object)"Must increase by at least 1");
        Preconditions.checkState((settings.pivotDecrement() > 0 ? 1 : 0) != 0, (Object)"Must decrease by at least 1");
        this.pivotIncrement = settings.pivotIncrement();
        this.pivotDecrement = settings.pivotDecrement();
        this.printSegmentSizes();
    }

    public static Set<Policy> policies(Config config) {
        FeedbackWindowTinyLfuSettings settings = new FeedbackWindowTinyLfuSettings(config);
        return settings.percentMain().stream().map(percentMain -> new FeedbackWindowTinyLfuPolicy((double)percentMain, settings)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        if (this.sample % this.sampleSize == 0) {
            ++this.sampled;
        }
        if (this.sample % (this.sampleSize / 2) == 0) {
            this.feedback.clear();
        }
        ++this.sample;
        this.admittor.record(key);
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else if (node.status == Status.WINDOW) {
            this.onWindowHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.PROBATION) {
            this.onProbationHit(node);
            this.policyStats.recordHit();
        } else if (node.status == Status.PROTECTED) {
            this.onProtectedHit(node);
            this.policyStats.recordHit();
        } else {
            throw new IllegalStateException();
        }
    }

    private void onMiss(long key) {
        Node node = new Node(key, Status.WINDOW);
        node.appendToTail(this.headWindow);
        this.data.put(key, (Object)node);
        ++this.sizeWindow;
        this.evict();
    }

    private void onWindowHit(Node node) {
        node.moveToTail(this.headWindow);
    }

    private void onProbationHit(Node node) {
        node.remove();
        node.status = Status.PROTECTED;
        node.appendToTail(this.headProtected);
        ++this.sizeProtected;
        this.demoteProtected();
    }

    private void demoteProtected() {
        if (this.sizeProtected > this.maxProtected) {
            Node demote = this.headProtected.next;
            demote.remove();
            demote.status = Status.PROBATION;
            demote.appendToTail(this.headProbation);
            --this.sizeProtected;
        }
    }

    private void onProtectedHit(Node node) {
        this.admittor.record(node.key);
        node.moveToTail(this.headProtected);
    }

    private void evict() {
        if (this.sizeWindow <= this.maxWindow) {
            return;
        }
        Node candidate = this.headWindow.next;
        --this.sizeWindow;
        candidate.remove();
        candidate.status = Status.PROBATION;
        candidate.appendToTail(this.headProbation);
        if (this.data.size() > this.maximumSize) {
            Node evict;
            Node victim = this.headProbation.next;
            if (this.admittor.admit(candidate.key, victim.key)) {
                evict = victim;
            } else if (this.adapt(candidate)) {
                evict = victim;
            } else {
                evict = candidate;
                this.feedback.put(candidate.key);
            }
            this.data.remove(evict.key);
            evict.remove();
            this.policyStats.recordEviction();
        }
    }

    private boolean adapt(Node candidate) {
        if (this.adjusted == this.sampled) {
            return false;
        }
        if (this.feedback.mightContain(candidate.key)) {
            this.adjusted = this.sampled;
            if (this.pivot < this.maxPivot) {
                ++this.pivot;
                ++this.maxWindow;
                ++this.sizeWindow;
                --this.maxProtected;
                this.demoteProtected();
                candidate.remove();
                candidate.status = Status.WINDOW;
                candidate.appendToTail(this.headWindow);
                int increments = Math.min(this.pivotIncrement - 1, this.maxPivot - this.pivot);
                for (int i = 0; i < increments; ++i) {
                    if (this.pivot >= this.maxPivot) continue;
                    ++this.pivot;
                    ++this.maxWindow;
                    ++this.sizeWindow;
                    --this.maxProtected;
                    this.demoteProtected();
                    candidate = this.headProbation.next.next;
                    candidate.remove();
                    candidate.status = Status.WINDOW;
                    candidate.appendToTail(this.headWindow);
                }
                if (this.trace) {
                    System.out.println("\u2191" + this.maxWindow);
                }
            }
            return true;
        }
        if (this.sampled > this.adjusted + 1) {
            this.adjusted = this.sampled;
            boolean decremented = false;
            for (int i = 0; i < this.pivotDecrement; ++i) {
                if (this.pivot <= 0) continue;
                --this.pivot;
                --this.maxWindow;
                --this.sizeWindow;
                ++this.maxProtected;
                decremented = true;
                candidate = this.headWindow.next;
                candidate.remove();
                candidate.status = Status.PROBATION;
                candidate.appendToHead(this.headProbation);
            }
            if (this.trace && decremented) {
                System.out.println("\u2193" + this.maxWindow);
            }
        }
        return false;
    }

    void printSegmentSizes() {
        if (this.debug) {
            System.out.printf("maxWindow=%d, maxProtected=%d, percentWindow=%.1f%n", this.maxWindow, this.maxProtected, (double)(100 * this.maxWindow) / (double)this.maximumSize);
        }
    }

    @Override
    public void finished() {
        this.printSegmentSizes();
        long windowSize = this.data.values().stream().filter(n -> n.status == Status.WINDOW).count();
        long probationSize = this.data.values().stream().filter(n -> n.status == Status.PROBATION).count();
        long protectedSize = this.data.values().stream().filter(n -> n.status == Status.PROTECTED).count();
        Preconditions.checkState((windowSize == (long)this.sizeWindow ? 1 : 0) != 0, (String)"%s != %s", (long)windowSize, (int)this.sizeWindow);
        Preconditions.checkState((protectedSize == (long)this.sizeProtected ? 1 : 0) != 0);
        Preconditions.checkState((probationSize == (long)this.data.size() - windowSize - protectedSize ? 1 : 0) != 0);
        Preconditions.checkState((this.data.size() <= this.maximumSize ? 1 : 0) != 0, (Object)this.data.size());
    }

    static final class FeedbackWindowTinyLfuSettings
    extends BasicSettings {
        public FeedbackWindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("feedback-window-tiny-lfu.percent-main");
        }

        public double percentMainProtected() {
            return this.config().getDouble("feedback-window-tiny-lfu.percent-main-protected");
        }

        public double percentPivot() {
            return this.config().getDouble("feedback-window-tiny-lfu.percent-pivot");
        }

        public int pivotIncrement() {
            return this.config().getInt("feedback-window-tiny-lfu.pivot-increment");
        }

        public int pivotDecrement() {
            return this.config().getInt("feedback-window-tiny-lfu.pivot-decrement");
        }

        public int maximumWindowSize() {
            return this.config().getInt("feedback-window-tiny-lfu.maximum-window-size");
        }

        public int maximumSampleSize() {
            return this.config().getInt("feedback-window-tiny-lfu.maximum-sample-size");
        }

        public double adaptiveFpp() {
            return this.config().getDouble("feedback-window-tiny-lfu.adaptive-fpp");
        }
    }

    static final class Node {
        final long key;
        Status status;
        Node prev;
        Node next;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, Status status) {
            this.status = status;
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToHead(Node head) {
            Node first = head.next;
            head.next = this;
            first.prev = this;
            this.prev = head;
            this.next = first;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("status", (Object)this.status).toString();
        }
    }

    static enum Status {
        WINDOW,
        PROBATION,
        PROTECTED;

    }
}

