/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.gradient;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.AbstractClimber;
import com.typesafe.config.Config;
import java.util.List;

public final class Nadam
extends AbstractClimber {
    private final int stepSize;
    private final double beta1;
    private final double beta2;
    private final double epsilon;
    private int t;
    private double moment;
    private double velocity;

    public Nadam(Config config) {
        NadamSettings settings = new NadamSettings(config);
        this.sampleSize = (int)(settings.percentSample() * (double)settings.maximumSize());
        this.stepSize = (int)(settings.percentPivot() * (double)settings.maximumSize());
        this.epsilon = settings.epsilon();
        this.beta1 = settings.beta1();
        this.beta2 = settings.beta2();
        this.t = 1;
    }

    @Override
    protected void resetSample(double hitRate) {
        super.resetSample(hitRate);
        ++this.t;
    }

    @Override
    protected double adjust(double hitRate) {
        double currentMissRate = 1.0 - hitRate;
        double previousMissRate = 1.0 - this.previousHitRate;
        double gradient = currentMissRate - previousMissRate;
        this.moment = this.beta1 * this.moment + (1.0 - this.beta1) * gradient;
        this.velocity = this.beta2 * this.velocity + (1.0 - this.beta2) * (gradient * gradient);
        double momentBias = this.moment / (1.0 - Math.pow(this.beta1, this.t));
        double velocityBias = this.velocity / (1.0 - Math.pow(this.beta2, this.t));
        return (double)this.stepSize / (Math.sqrt(velocityBias) + this.epsilon) * (this.beta1 * momentBias + (1.0 - this.beta1) / (1.0 - Math.pow(this.beta1, this.t)) * gradient);
    }

    static final class NadamSettings
    extends BasicSettings {
        static final String BASE_PATH = "hill-climber-window-tiny-lfu.nadam.";

        public NadamSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("hill-climber-window-tiny-lfu.percent-main");
        }

        public double percentPivot() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.nadam.percent-pivot");
        }

        public double percentSample() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.nadam.percent-sample");
        }

        public double beta1() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.nadam.beta1");
        }

        public double beta2() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.nadam.beta2");
        }

        public double epsilon() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.nadam.epsilon");
        }
    }
}

