/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.Metrics;
import com.github.benmanes.caffeine.cache.simulator.report.TextReporter;
import com.google.common.base.Stopwatch;
import com.typesafe.config.Config;
import de.siegmar.fastcsv.writer.CsvWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class CsvReporter
extends TextReporter {
    public CsvReporter(Config config, Set<Policy.Characteristic> characteristics) {
        super(config, characteristics);
    }

    @Override
    protected void write(Writer writer, Set<String> headers, List<PolicyStats> results) throws IOException {
        try (CsvWriter csv = CsvWriter.builder().build(writer);){
            csv.writeRecord(headers);
            for (PolicyStats policyStats : results) {
                csv.writeRecord(headers.stream().map(policyStats.metrics()::get).map(this.metrics()::format).toList());
            }
        }
    }

    @Override
    protected Metrics metrics() {
        return Metrics.builder().percentFormatter(value -> String.format(Locale.US, "%.2f", 100.0 * value)).doubleFormatter(value -> String.format(Locale.US, "%.2f", value)).longFormatter(Long::toString).objectFormatter(object -> {
            String string;
            if (object instanceof Stopwatch) {
                Stopwatch stopwatch = (Stopwatch)object;
                string = Long.toString(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            } else {
                string = object.toString();
            }
            return string;
        }).build();
    }
}

