/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="sketch.LruWindowTinyLfu")
public final class LruWindowTinyLfuPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final Admittor admittor;
    private final Node headWindow;
    private final Node headMain;
    private final int maxWindow;
    private final int maxMain;
    private int sizeWindow;
    private int sizeMain;

    public LruWindowTinyLfuPolicy(double percentMain, LruWindowTinyLfuSettings settings) {
        this.policyStats = new PolicyStats(this.name() + " (%.0f%%)", 100.0 * (1.0 - percentMain));
        int maximumSize = Math.toIntExact(settings.maximumSize());
        this.admittor = Admission.TINYLFU.from(settings.config(), this.policyStats);
        this.maxMain = (int)((double)maximumSize * percentMain);
        this.data = new Long2ObjectOpenHashMap();
        this.maxWindow = maximumSize - this.maxMain;
        this.headWindow = new Node();
        this.headMain = new Node();
    }

    public static Set<Policy> policies(Config config) {
        LruWindowTinyLfuSettings settings = new LruWindowTinyLfuSettings(config);
        return settings.percentMain().stream().map(percentMain -> new LruWindowTinyLfuPolicy((double)percentMain, settings)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        if (node == null) {
            node = new Node(key, Status.WINDOW);
            node.appendToTail(this.headWindow);
            this.data.put(key, (Object)node);
            ++this.sizeWindow;
            this.evict();
            this.policyStats.recordMiss();
        } else if (node.status == Status.WINDOW) {
            node.moveToTail(this.headWindow);
            this.policyStats.recordHit();
        } else if (node.status == Status.MAIN) {
            node.moveToTail(this.headMain);
            this.policyStats.recordHit();
        } else {
            throw new IllegalStateException();
        }
    }

    private void evict() {
        if (this.sizeWindow <= this.maxWindow) {
            return;
        }
        Node candidate = Objects.requireNonNull(this.headWindow.next);
        candidate.remove();
        --this.sizeWindow;
        candidate.appendToTail(this.headMain);
        candidate.status = Status.MAIN;
        ++this.sizeMain;
        if (this.sizeMain > this.maxMain) {
            Node victim = Objects.requireNonNull(this.headMain.next);
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.data.remove(evict.key);
            evict.remove();
            --this.sizeMain;
            this.policyStats.recordEviction();
        }
    }

    @Override
    public void finished() {
        Preconditions.checkState((this.data.values().stream().filter(n -> n.status == Status.WINDOW).count() == (long)this.sizeWindow ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeWindow + this.sizeMain == this.data.size() ? 1 : 0) != 0);
        Preconditions.checkState((this.data.size() <= this.maxWindow + this.maxMain ? 1 : 0) != 0);
    }

    public static final class LruWindowTinyLfuSettings
    extends BasicSettings {
        public LruWindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("lru-window-tiny-lfu.percent-main");
        }
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        @Nullable Status status;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, Status status) {
            this.status = status;
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToTail(Node head) {
            Objects.requireNonNull(head.prev);
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).toString();
        }
    }

    static enum Status {
        WINDOW,
        MAIN;

    }
}

