/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.Metrics;
import com.github.benmanes.caffeine.cache.simulator.report.TextReporter;
import com.google.common.base.Stopwatch;
import com.typesafe.config.Config;
import de.siegmar.fastcsv.writer.CsvWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class CsvReporter
extends TextReporter {
    public CsvReporter(Config config, Set<Policy.Characteristic> characteristics) {
        super(config, characteristics);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String assemble(Set<String> headers, List<PolicyStats> results) {
        try (StringWriter output = new StringWriter();){
            String string;
            block14: {
                CsvWriter writer = CsvWriter.builder().build((Writer)output);
                try {
                    writer.writeRecord(headers);
                    for (PolicyStats policyStats : results) {
                        writer.writeRecord(headers.stream().map(policyStats.metrics()::get).map(this.metrics()::format).toList());
                    }
                    string = output.toString();
                    if (writer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected Metrics metrics() {
        return Metrics.builder().percentFormatter(value -> String.format(Locale.US, "%.2f", 100.0 * value)).doubleFormatter(value -> String.format(Locale.US, "%.2f", value)).longFormatter(Long::toString).objectFormatter(object -> {
            String string;
            if (object instanceof Stopwatch) {
                Stopwatch stopwatch = (Stopwatch)object;
                string = Long.toString(stopwatch.elapsed(TimeUnit.MILLISECONDS));
            } else {
                string = object.toString();
            }
            return string;
        }).build();
    }
}

