/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.UnmodifiableIterator;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.NamedCsvRecord;
import de.siegmar.fastcsv.writer.CsvWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Stream;

public record CombinedCsvReport(ImmutableMap<Long, Path> inputFiles, String metric, Path outputFile) implements Runnable
{
    private static final String POLICY_KEY = "Policy";

    public CombinedCsvReport {
        inputFiles = ImmutableSortedMap.copyOf(inputFiles);
        metric = metric.replace('_', ' ');
        Objects.requireNonNull(outputFile);
    }

    @Override
    public void run() {
        this.writeReport(this.tabulate());
    }

    private Map<Label, String> tabulate() {
        TreeMap<Label, String> results = new TreeMap<Label, String>();
        this.inputFiles.forEach((maximumSize, path) -> {
            try (CsvReader reader = CsvReader.builder().ofNamedCsvRecord(path);){
                for (NamedCsvRecord record : reader) {
                    Label label = new Label(record.getField(POLICY_KEY), (long)maximumSize);
                    results.put(label, record.findField(this.metric).orElse(""));
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return results;
    }

    private void writeReport(Map<Label, String> table) {
        NumberFormat formatter = NumberFormat.getInstance(Locale.US);
        ImmutableList headers = (ImmutableList)Stream.concat(Stream.of(POLICY_KEY), this.inputFiles.keySet().stream().map(formatter::format)).collect(ImmutableList.toImmutableList());
        try (CsvWriter writer = CsvWriter.builder().build(this.outputFile, new OpenOption[0]);){
            writer.writeRecord((Iterable)headers);
            for (String policy : this.policies()) {
                ArrayList<String> values = new ArrayList<String>();
                values.add(policy);
                UnmodifiableIterator unmodifiableIterator = this.inputFiles.keySet().iterator();
                while (unmodifiableIterator.hasNext()) {
                    long size = (Long)unmodifiableIterator.next();
                    values.add(table.get(new Label(policy, size)));
                }
                writer.writeRecord(values);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ImmutableList<String> policies() {
        ImmutableList immutableList;
        block8: {
            Path input = (Path)this.inputFiles.values().iterator().next();
            CsvReader reader = CsvReader.builder().ofNamedCsvRecord(input);
            try {
                immutableList = (ImmutableList)reader.stream().map(record -> record.getField(POLICY_KEY)).collect(ImmutableList.toImmutableList());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            reader.close();
        }
        return immutableList;
    }

    private record Label(String policy, long size) implements Comparable<Label>
    {
        Label {
            Objects.requireNonNull(policy);
        }

        @Override
        public int compareTo(Label label) {
            int ordering = this.policy.compareTo(label.policy);
            return ordering == 0 ? Long.compare(this.size, label.size) : ordering;
        }
    }
}

