/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.jodah.expiringmap.ExpirationPolicy;
import net.jodah.expiringmap.ExpiringMap;

@Policy.PolicySpec(name="product.ExpiringMap")
public final class ExpiringMapPolicy
implements Policy {
    private final Map<Long, Boolean> cache;
    private final PolicyStats policyStats;
    private final int maximumSize;

    public ExpiringMapPolicy(ExpiringMapSettings settings, Eviction policy) {
        this.policyStats = new PolicyStats(this.name() + " (%s)", new Object[]{policy});
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.cache = ExpiringMap.builder().expirationPolicy(policy.type).maxSize(this.maximumSize).build();
    }

    public static Set<Policy> policies(Config config) {
        ExpiringMapSettings settings = new ExpiringMapSettings(config);
        return settings.policy().stream().map(policy -> new ExpiringMapPolicy(settings, (Eviction)((Object)policy))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(AccessEvent event) {
        Long key = event.longKey();
        Boolean value = this.cache.get(key);
        if (value == null) {
            if (this.cache.size() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put(key, Boolean.TRUE);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    public static final class ExpiringMapSettings
    extends BasicSettings {
        public ExpiringMapSettings(Config config) {
            super(config);
        }

        public ImmutableSet<Eviction> policy() {
            return (ImmutableSet)this.config().getStringList("expiring-map.policy").stream().map(policy -> (Eviction)((Object)((Object)Enums.getIfPresent(Eviction.class, (String)policy.toUpperCase(Locale.US)).toJavaUtil().orElseThrow(() -> new IllegalArgumentException("Unknown policy: " + policy))))).collect(Sets.toImmutableEnumSet());
        }
    }

    public static enum Eviction {
        FIFO(ExpirationPolicy.CREATED),
        LRU(ExpirationPolicy.ACCESSED);

        final ExpirationPolicy type;

        private Eviction(ExpirationPolicy type) {
            this.type = type;
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }
}

