/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Stream;

public final class CombinedCsvReport
implements Runnable {
    private final SortedMap<Long, Path> inputFiles;
    private final Path outputFile;
    private final String metric;

    public CombinedCsvReport(SortedMap<Long, Path> inputFiles, String metric, Path outputFile) {
        this.inputFiles = Objects.requireNonNull(inputFiles);
        this.outputFile = Objects.requireNonNull(outputFile);
        this.metric = metric.replace('_', ' ');
    }

    @Override
    public void run() {
        this.writeReport(this.tabulate());
    }

    private Table<String, Long, String> tabulate() {
        HashBasedTable results = HashBasedTable.create();
        this.inputFiles.forEach((arg_0, arg_1) -> this.lambda$tabulate$0((Table)results, arg_0, arg_1));
        return results;
    }

    private void writeReport(Table<String, Long, String> table) {
        ImmutableList policies = (ImmutableList)this.newCsvParser().parseAllRecords(this.inputFiles.values().iterator().next().toFile()).stream().map(record -> record.getString("Policy")).collect(ImmutableList.toImmutableList());
        NumberFormat formatter = NumberFormat.getInstance(Locale.US);
        String[] headers = (String[])Stream.concat(Stream.of("Policy"), this.inputFiles.keySet().stream().map(formatter::format)).toArray(String[]::new);
        CsvWriter writer = this.newWriter(headers);
        for (String policy : policies) {
            writer.addValue("Policy", (Object)policy);
            for (Long size : this.inputFiles.keySet()) {
                writer.addValue(formatter.format(size), table.get((Object)policy, (Object)size));
            }
            writer.writeValuesToRow();
        }
        writer.close();
    }

    private CsvParser newCsvParser() {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setHeaderExtractionEnabled(true);
        return new CsvParser(settings);
    }

    private CsvWriter newWriter(String[] headers) {
        CsvWriterSettings settings = new CsvWriterSettings();
        settings.setHeaderWritingEnabled(true);
        settings.setHeaders(headers);
        return new CsvWriter(this.outputFile.toFile(), settings);
    }

    private /* synthetic */ void lambda$tabulate$0(Table results, Long maximumSize, Path path) {
        List records = this.newCsvParser().parseAllRecords(path.toFile());
        for (Record record : records) {
            results.put((Object)record.getString("Policy"), (Object)maximumSize, (Object)((String)record.getValue(this.metric, (Object)"")));
        }
    }
}

