/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.CaseFormat;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.typesafe.config.Config;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="product.Coherence", characteristics={Policy.Characteristic.WEIGHTED})
public final class CoherencePolicy
implements Policy {
    private final PolicyStats policyStats;
    private final LocalCache cache;

    public CoherencePolicy(CoherenceSettings settings, Eviction policy) {
        this.policyStats = new PolicyStats(this.name() + " (%s)", new Object[]{policy});
        int factor = 1;
        long maximum = settings.maximumSize();
        while (maximum >= Integer.MAX_VALUE) {
            maximum /= 1024L;
            factor *= 1024;
        }
        this.cache = new LocalCache();
        this.cache.setUnitFactor(factor);
        this.cache.setHighUnits((int)maximum);
        this.cache.setEvictionType(policy.type);
        this.cache.addMapListener((MapListener)new CoherenceListener());
        this.cache.setUnitCalculator((ConfigurableCacheMap.UnitCalculator)new AccessEventCalculator());
    }

    public static Set<Policy> policies(Config config) {
        CoherenceSettings settings = new CoherenceSettings(config);
        return settings.policy().stream().map(policy -> new CoherencePolicy(settings, (Eviction)((Object)policy))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(AccessEvent event) {
        AccessEvent value = (AccessEvent)this.cache.get((Object)event.key());
        if (value == null) {
            this.cache.put((Object)event.key(), (Object)event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            if (event.weight() != value.weight()) {
                this.cache.put((Object)event.key(), (Object)event);
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static enum Eviction {
        HYBRID(0),
        LRU(1),
        LFU(2);

        final int type;

        private Eviction(int type) {
            this.type = type;
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    static final class CoherenceSettings
    extends BasicSettings {
        public CoherenceSettings(Config config) {
            super(config);
        }

        public Set<Eviction> policy() {
            EnumSet<Eviction> policies = EnumSet.noneOf(Eviction.class);
            for (String policy : this.config().getStringList("coherence.policy")) {
                if (policy.equalsIgnoreCase("hybrid")) {
                    policies.add(Eviction.HYBRID);
                    continue;
                }
                if (policy.equalsIgnoreCase("lfu")) {
                    policies.add(Eviction.LFU);
                    continue;
                }
                if (policy.equalsIgnoreCase("lru")) {
                    policies.add(Eviction.LRU);
                    continue;
                }
                throw new IllegalArgumentException("Unknown policy: " + policy);
            }
            return policies;
        }
    }

    private static final class AccessEventCalculator
    implements ConfigurableCacheMap.UnitCalculator {
        private AccessEventCalculator() {
        }

        public String getName() {
            return "Coherence";
        }

        public int calculateUnits(Object key, Object value) {
            return ((AccessEvent)value).weight();
        }
    }

    private final class CoherenceListener
    implements MapListener<Object, Object> {
        private CoherenceListener() {
        }

        public void entryInserted(MapEvent<Object, Object> event) {
        }

        public void entryUpdated(MapEvent<Object, Object> event) {
        }

        public void entryDeleted(MapEvent<Object, Object> event) {
            CoherencePolicy.this.policyStats.recordEviction();
        }
    }
}

