/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.linked;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="linked.SegmentedLru")
public final class SegmentedLruPolicy
implements Policy.KeyOnlyPolicy {
    static final Node UNLINKED = new Node();
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final Node headProtected;
    final Node headProbation;
    final Admittor admittor;
    final int maxProtected;
    final int maximumSize;
    int sizeProtected;

    public SegmentedLruPolicy(Admission admission, Config config) {
        this.policyStats = new PolicyStats(admission.format(this.name()), new Object[0]);
        this.admittor = admission.from(config, this.policyStats);
        SegmentedLruSettings settings = new SegmentedLruSettings(config);
        this.headProtected = new Node();
        this.headProbation = new Node();
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maxProtected = (int)((double)this.maximumSize * settings.percentProtected());
    }

    public static Set<Policy> policies(Config config) {
        BasicSettings settings = new BasicSettings(config);
        return settings.admission().stream().map(admission -> new SegmentedLruPolicy((Admission)((Object)admission), config)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        if (node == null) {
            this.onMiss(key);
        } else {
            this.onHit(node);
        }
    }

    private void onHit(Node node) {
        if (node.type == QueueType.PROTECTED) {
            node.moveToTail(this.headProtected);
        } else {
            ++this.sizeProtected;
            if (this.sizeProtected > this.maxProtected) {
                Node demote = this.headProtected.next;
                demote.remove();
                demote.type = QueueType.PROBATION;
                demote.appendToTail(this.headProbation);
                --this.sizeProtected;
            }
            node.remove();
            node.type = QueueType.PROTECTED;
            node.appendToTail(this.headProtected);
        }
        this.policyStats.recordHit();
    }

    private void onMiss(long key) {
        Node node = new Node(key);
        this.data.put(key, (Object)node);
        this.policyStats.recordMiss();
        node.appendToTail(this.headProbation);
        node.type = QueueType.PROBATION;
        this.evict(node);
    }

    private void evict(Node candidate) {
        if (this.data.size() > this.maximumSize) {
            Node victim = this.maxProtected == 0 ? this.headProtected.next : this.headProbation.next;
            this.policyStats.recordEviction();
            boolean admit = this.admittor.admit(candidate.key, victim.key);
            if (admit) {
                this.evictEntry(victim);
            } else {
                this.evictEntry(candidate);
            }
        }
    }

    private void evictEntry(Node node) {
        this.data.remove(node.key);
        node.remove();
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class SegmentedLruSettings
    extends BasicSettings {
        public SegmentedLruSettings(Config config) {
            super(config);
        }

        public double percentProtected() {
            return this.config().getDouble("segmented-lru.percent-protected");
        }
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;
        QueueType type;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
            this.prev = UNLINKED;
            this.next = UNLINKED;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void moveToTail(Node head) {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = head;
            this.prev = head.prev;
            head.prev = this;
            this.prev.next = this;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this.next = UNLINKED;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    static enum QueueType {
        PROTECTED,
        PROBATION;

    }
}

