/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.OutputFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceWriter;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.google.common.base.CaseFormat;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true)
public final class Rewriter
implements Runnable {
    @CommandLine.Option(names={"--inputFiles"}, required=true, split=",", description={"The trace input files. To use a mix of formats, specify the entry as format:path, e.g. lirs:loop.trace.gz"})
    private List<String> inputFiles;
    @CommandLine.Option(names={"--inputFormat"}, required=true, description={"The default trace input format"})
    private TraceFormat inputFormat;
    @CommandLine.Option(names={"--outputFile"}, required=true, description={"The trace output file"})
    private Path outputFile;
    @CommandLine.Option(names={"--outputFormat"}, required=true, description={"The trace output format"})
    private OutputFormat outputFormat;

    @Override
    public void run() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try (BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(this.outputFile, new OpenOption[0]));
             Stream<AccessEvent> events = this.inputFormat.readFiles(this.inputFiles).events();
             TraceWriter writer = this.outputFormat.writer(output);){
            int[] tick = new int[]{0};
            writer.writeHeader();
            events.forEach(event -> {
                try {
                    writer.writeEvent(tick[0], (AccessEvent)event);
                    tick[0] = tick[0] + 1;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            writer.writeFooter();
            System.out.printf("Rewrote %,d events from %,d input(s) in %s%n", tick[0], this.inputFiles.size(), stopwatch);
            System.out.printf("Output in %s format to %s%n", CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, this.outputFormat.name()), this.outputFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static String[] argumentsWithDefaults(String[] args) {
        ArrayList params = Lists.newArrayList((Object[])args);
        if (!params.contains("--inputFormat")) {
            boolean found = false;
            boolean defaultFormat = true;
            for (int i = 0; i < args.length - 1; ++i) {
                if (!Objects.equals(args[i], "--inputFiles")) continue;
                defaultFormat &= args[i + 1].contains(":");
                found = true;
            }
            if (found && defaultFormat) {
                params.addAll(List.of("--inputFormat", TraceFormat.values()[0].name()));
            }
        }
        return (String[])params.toArray(String[]::new);
    }

    public static void main(String[] args) {
        new CommandLine(Rewriter.class).setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON)).setCommandName(Rewriter.class.getSimpleName()).setCaseInsensitiveEnumValuesAllowed(true).execute(Rewriter.argumentsWithDefaults(args));
    }
}

