/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import java.util.Set;

public final class ClockProPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private Node handHot;
    private Node handCold;
    private Node handTest;
    private final int maximumSize;
    private int maximumColdSize;
    private int sizeHot;
    private int sizeCold;
    private int sizeTest;

    public ClockProPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.policyStats = new PolicyStats("irr.ClockPro");
        this.data = new Long2ObjectOpenHashMap();
        this.maximumColdSize = this.maximumSize;
        this.handTest = null;
        this.handCold = null;
        this.handHot = null;
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new ClockProPolicy(config));
    }

    @Override
    public void record(long key) {
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
        } else if (node.status == Status.TEST) {
            this.onNonResidentHit(node);
        } else {
            this.onHit(node);
        }
    }

    private void onMiss(long key) {
        this.policyStats.recordOperation();
        this.policyStats.recordMiss();
        Node node = new Node(key);
        this.data.put(key, (Object)node);
        this.add(node);
        ++this.sizeCold;
        Preconditions.checkState((this.sizeHot + this.sizeCold <= this.maximumSize ? 1 : 0) != 0);
    }

    private void onNonResidentHit(Node node) {
        this.policyStats.recordOperation();
        this.policyStats.recordMiss();
        if (this.maximumColdSize < this.maximumSize) {
            ++this.maximumColdSize;
        }
        this.delete(node);
        --this.sizeTest;
        Preconditions.checkState((this.sizeTest >= 0 ? 1 : 0) != 0);
        node.status = Status.HOT;
        this.add(node);
        ++this.sizeHot;
        Preconditions.checkState((this.sizeHot + this.sizeCold <= this.maximumSize ? 1 : 0) != 0);
    }

    private void onHit(Node node) {
        this.policyStats.recordOperation();
        this.policyStats.recordHit();
        node.marked = true;
    }

    private void add(Node node) {
        this.evict();
        if (this.handHot == null) {
            this.handCold = this.handTest = node;
            this.handHot = this.handTest;
            node.next = node.prev = node;
        } else {
            node.prev = this.handHot;
            node.next = this.handHot.next;
            this.handHot.next.prev = node;
            this.handHot.next = node;
        }
        if (this.handCold == this.handHot) {
            this.handCold = node.next;
        }
        if (this.handTest == this.handHot) {
            this.handTest = node.next;
        }
        this.handHot = node.next;
    }

    private void delete(Node node) {
        if (this.handHot == node) {
            this.handHot = node.next;
        }
        if (this.handCold == node) {
            this.handCold = node.next;
        }
        if (this.handTest == node) {
            this.handTest = node.next;
        }
        node.remove();
    }

    private void evict() {
        while (this.maximumSize <= this.sizeHot + this.sizeCold) {
            this.policyStats.recordOperation();
            this.scanCold();
        }
    }

    private void scanHot() {
        if (this.handHot == this.handTest) {
            this.scanTest();
        }
        if (this.handHot.status == Status.HOT) {
            if (this.handHot.marked) {
                this.handHot.marked = false;
            } else {
                this.handHot.status = Status.COLD;
                ++this.sizeCold;
                --this.sizeHot;
            }
        }
        this.handHot = this.handHot.next;
    }

    private void scanCold() {
        if (this.handCold.status == Status.COLD) {
            if (this.handCold.marked) {
                this.handCold.status = Status.HOT;
                this.handCold.marked = false;
                --this.sizeCold;
                ++this.sizeHot;
            } else {
                this.policyStats.recordEviction();
                this.handCold.status = Status.TEST;
                --this.sizeCold;
                ++this.sizeTest;
                while (this.maximumSize < this.sizeTest) {
                    this.policyStats.recordOperation();
                    this.scanTest();
                }
            }
            Preconditions.checkState((this.sizeCold >= 0 ? 1 : 0) != 0);
        }
        this.handCold = this.handCold.next;
        while (this.maximumSize - this.maximumColdSize < this.sizeHot) {
            this.policyStats.recordOperation();
            this.scanHot();
        }
    }

    private void scanTest() {
        if (this.handTest == this.handCold) {
            this.scanCold();
        }
        if (this.handTest.status == Status.TEST) {
            Objects.requireNonNull((Node)this.data.remove(this.handTest.key));
            this.delete(this.handTest);
            --this.sizeTest;
            if (this.maximumColdSize > 1) {
                --this.maximumColdSize;
            }
        }
        this.handTest = this.handTest.next;
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Preconditions.checkState((this.sizeHot + this.sizeCold + this.sizeTest == this.data.size() ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeHot + this.sizeCold <= this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState((this.maximumColdSize <= this.maximumSize ? 1 : 0) != 0);
    }

    private static final class Node {
        final long key;
        boolean marked;
        Status status = Status.COLD;
        Node prev;
        Node next;

        public Node(long key) {
            this.key = key;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }
    }

    static enum Status {
        HOT,
        COLD,
        TEST;

    }
}

