/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.caffinitas.ohc.CacheSerializer;
import org.caffinitas.ohc.Eviction;
import org.caffinitas.ohc.OHCache;
import org.caffinitas.ohc.OHCacheBuilder;

public final class OhcPolicy
implements Policy.KeyOnlyPolicy {
    private static final long ENTRY_SIZE = 80L;
    private final OHCache<Long, Long> cache;
    private final PolicyStats policyStats;
    static final CacheSerializer<Long> longSerializer = new CacheSerializer<Long>(){

        public void serialize(Long value, ByteBuffer buffer) {
            buffer.putLong(value);
        }

        public Long deserialize(ByteBuffer buffer) {
            return buffer.getLong();
        }

        public int serializedSize(Long value) {
            return 8;
        }
    };

    public OhcPolicy(OhcSettings settings, Eviction policy) {
        this.cache = OHCacheBuilder.newBuilder().capacity(80L * (long)settings.maximumSize()).edenSize(settings.percentEden()).valueSerializer(longSerializer).keySerializer(longSerializer).eviction(policy).build();
        this.policyStats = new PolicyStats(String.format("product.OHC (%s)", policy == Eviction.LRU ? "Lru" : "W-TinyLfu"));
    }

    public static Set<Policy> policies(Config config) {
        OhcSettings settings = new OhcSettings(config);
        return settings.policy().stream().map(policy -> new OhcPolicy(settings, (Eviction)policy)).collect(Collectors.toSet());
    }

    @Override
    public void record(long key) {
        Object value = this.cache.get((Object)key);
        if (value == null) {
            this.cache.put((Object)key, (Object)key);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.policyStats.addEvictions(this.cache.stats().getEvictionCount());
        Preconditions.checkState((this.policyStats.hitCount() == this.cache.stats().getHitCount() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == this.cache.stats().getMissCount() ? 1 : 0) != 0);
        try {
            this.cache.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static final class OhcSettings
    extends BasicSettings {
        public OhcSettings(Config config) {
            super(config);
        }

        public double percentEden() {
            return this.config().getDouble("ohc.percent-eden");
        }

        public Set<Eviction> policy() {
            HashSet<Eviction> policies = new HashSet<Eviction>();
            for (String policy : this.config().getStringList("ohc.policy")) {
                String name = policy.toLowerCase(Locale.US).replaceAll("[^a-z]", "");
                if (name.equals("lru")) {
                    policies.add(Eviction.LRU);
                    continue;
                }
                if (name.equals("wtinylfu")) {
                    policies.add(Eviction.W_TINY_LFU);
                    continue;
                }
                throw new IllegalArgumentException("Unknown policy: " + policy);
            }
            return policies;
        }
    }
}

