/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.cache2k.Cache;
import org.cache2k.Cache2kBuilder;

public final class Cache2kPolicy
implements Policy {
    private static final Logger logger = Logger.getLogger("org.cache2k");
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats;
    private final int maximumSize;

    public Cache2kPolicy(Config config) {
        logger.setLevel(Level.WARNING);
        this.policyStats = new PolicyStats("product.Cache2k");
        BasicSettings settings = new BasicSettings(config);
        this.cache = Cache2kBuilder.of(Object.class, Object.class).entryCapacity((long)settings.maximumSize()).strictEviction(true).eternal(true).build();
        this.maximumSize = settings.maximumSize();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new Cache2kPolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.peek((Object)key);
        if (value == null) {
            this.policyStats.recordMiss();
            if (this.cache.asMap().size() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.put((Object)key, (Object)key);
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.cache.close();
    }
}

