/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import com.github.benmanes.caffeine.jcache.CacheFactory;
import com.github.benmanes.caffeine.jcache.CacheProxy;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.jspecify.annotations.Nullable;

public final class CacheManagerImpl
implements CacheManager {
    final WeakReference<ClassLoader> classLoaderReference;
    final Map<String, CacheProxy<?, ?>> caches;
    final CachingProvider cacheProvider;
    final Properties properties;
    final Object lock;
    final URI uri;
    final boolean runsAsAnOsgiBundle;
    volatile boolean closed;

    public CacheManagerImpl(CachingProvider cacheProvider, boolean runsAsAnOsgiBundle, URI uri, ClassLoader classLoader, Properties properties) {
        this.classLoaderReference = new WeakReference<ClassLoader>(Objects.requireNonNull(classLoader));
        this.cacheProvider = Objects.requireNonNull(cacheProvider);
        this.runsAsAnOsgiBundle = runsAsAnOsgiBundle;
        this.properties = Objects.requireNonNull(properties);
        this.caches = new ConcurrentHashMap();
        this.uri = Objects.requireNonNull(uri);
        this.lock = new Object();
    }

    public CachingProvider getCachingProvider() {
        return this.cacheProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public @Nullable ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderReference.get();
    }

    public Properties getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            CacheProxy castedCache;
            if (this.runsAsAnOsgiBundle) {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            this.requireNotClosed();
            Objects.requireNonNull(configuration);
            CacheProxy cache = this.caches.compute(cacheName, (name, existing) -> {
                if (existing != null) {
                    throw new CacheException("Cache " + cacheName + " already exists");
                }
                if (CacheFactory.isDefinedExternally(this, cacheName)) {
                    throw new CacheException("Cache " + cacheName + " is configured externally");
                }
                return CacheFactory.createCache(this, cacheName, configuration);
            });
            CompleteConfiguration config = cache.getConfiguration(CompleteConfiguration.class);
            this.enableManagement(cache.getName(), config.isManagementEnabled());
            this.enableStatistics(cache.getName(), config.isStatisticsEnabled());
            CacheProxy cacheProxy = castedCache = cache;
            return cacheProxy;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> @Nullable Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Cache cache;
            if (this.runsAsAnOsgiBundle) {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            if ((cache = this.getCache(cacheName)) == null) {
                Cache<K, V> cache2 = null;
                return cache2;
            }
            Objects.requireNonNull(keyType);
            Objects.requireNonNull(valueType);
            CompleteConfiguration config = cache.getConfiguration(CompleteConfiguration.class);
            if (keyType != config.getKeyType()) {
                throw new ClassCastException("Incompatible cache key types specified, expected " + String.valueOf(config.getKeyType()) + " but " + String.valueOf(keyType) + " was specified");
            }
            if (valueType != config.getValueType()) {
                throw new ClassCastException("Incompatible cache value types specified, expected " + String.valueOf(config.getValueType()) + " but " + String.valueOf(valueType) + " was specified");
            }
            Cache cache3 = cache;
            return cache3;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, V> CacheProxy<K, V> getCache(String cacheName) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            CacheProxy cache;
            CacheProxy castedCache;
            if (this.runsAsAnOsgiBundle) {
                Thread.currentThread().setContextClassLoader(this.getClassLoader());
            }
            Objects.requireNonNull(cacheName);
            this.requireNotClosed();
            CacheProxy cacheProxy = castedCache = (cache = this.caches.computeIfAbsent(cacheName, name -> {
                CacheProxy created = CacheFactory.tryToCreateFromExternalSettings(this, name);
                if (created != null) {
                    CompleteConfiguration config = created.getConfiguration(CompleteConfiguration.class);
                    created.enableManagement(config.isManagementEnabled());
                    created.enableStatistics(config.isStatisticsEnabled());
                }
                return created;
            }));
            return cacheProxy;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public Collection<String> getCacheNames() {
        this.requireNotClosed();
        return Collections.unmodifiableCollection(new ArrayList<String>(this.caches.keySet()));
    }

    public void destroyCache(String cacheName) {
        this.requireNotClosed();
        Cache cache = this.caches.remove(cacheName);
        if (cache != null) {
            cache.close();
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.requireNotClosed();
        CacheProxy<?, ?> cache = this.caches.get(cacheName);
        if (cache == null) {
            return;
        }
        cache.enableManagement(enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.requireNotClosed();
        CacheProxy<?, ?> cache = this.caches.get(cacheName);
        if (cache == null) {
            return;
        }
        cache.enableStatistics(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isClosed()) {
                this.cacheProvider.close(this.uri, (ClassLoader)this.classLoaderReference.get());
                for (Cache cache : this.caches.values()) {
                    cache.close();
                }
                this.closed = true;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + String.valueOf(clazz) + " is not a supported by this implementation");
    }

    private void requireNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
    }
}

