/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.configuration;

import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.jcache.copy.Copier;
import com.github.benmanes.caffeine.jcache.copy.JavaSerializationCopier;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheWriter;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class CaffeineConfiguration<K, V>
implements CompleteConfiguration<K, V> {
    private static final Factory<Scheduler> DISABLED_SCHEDULER = Scheduler::disabledScheduler;
    private static final Factory<Copier> JAVA_COPIER = JavaSerializationCopier::new;
    private static final Factory<Executor> COMMON_POOL = ForkJoinPool::commonPool;
    private static final Factory<Ticker> SYSTEM_TICKER = Ticker::systemTicker;
    private static final long serialVersionUID = 1L;
    private final MutableConfiguration<K, V> delegate;
    private final boolean readOnly;
    private @Nullable Factory<Weigher<K, V>> weigherFactory;
    private @Nullable Factory<Expiry<K, V>> expiryFactory;
    private Factory<Scheduler> schedulerFactory;
    private Factory<Executor> executorFactory;
    private Factory<Copier> copierFactory;
    private Factory<Ticker> tickerFactory;
    private @Nullable Long refreshAfterWriteNanos;
    private @Nullable Long expireAfterAccessNanos;
    private @Nullable Long expireAfterWriteNanos;
    private @Nullable Long maximumWeight;
    private @Nullable Long maximumSize;
    private boolean nativeStatistics;

    public CaffeineConfiguration() {
        this.delegate = new MutableConfiguration();
        this.delegate.setStoreByValue(false);
        this.schedulerFactory = DISABLED_SCHEDULER;
        this.tickerFactory = SYSTEM_TICKER;
        this.executorFactory = COMMON_POOL;
        this.copierFactory = JAVA_COPIER;
        this.readOnly = false;
    }

    public CaffeineConfiguration(CompleteConfiguration<K, V> configuration) {
        this(configuration, false);
    }

    private CaffeineConfiguration(CompleteConfiguration<K, V> configuration, boolean readOnly) {
        this.delegate = new MutableConfiguration(configuration);
        if (configuration instanceof CaffeineConfiguration) {
            CaffeineConfiguration config = (CaffeineConfiguration)configuration;
            this.refreshAfterWriteNanos = config.refreshAfterWriteNanos;
            this.expireAfterAccessNanos = config.expireAfterAccessNanos;
            this.expireAfterWriteNanos = config.expireAfterWriteNanos;
            this.nativeStatistics = config.nativeStatistics;
            this.schedulerFactory = config.schedulerFactory;
            this.executorFactory = config.executorFactory;
            this.expiryFactory = config.expiryFactory;
            this.copierFactory = config.copierFactory;
            this.tickerFactory = config.tickerFactory;
            this.weigherFactory = config.weigherFactory;
            this.maximumWeight = config.maximumWeight;
            this.maximumSize = config.maximumSize;
        } else {
            this.schedulerFactory = DISABLED_SCHEDULER;
            this.tickerFactory = SYSTEM_TICKER;
            this.executorFactory = COMMON_POOL;
            this.copierFactory = JAVA_COPIER;
        }
        this.readOnly = readOnly;
    }

    public CaffeineConfiguration<K, V> immutableCopy() {
        return new CaffeineConfiguration<K, V>(this, true);
    }

    private void checkIfReadOnly() {
        if (this.readOnly) {
            throw new UnsupportedOperationException();
        }
    }

    public Class<K> getKeyType() {
        return this.delegate.getKeyType();
    }

    public Class<V> getValueType() {
        return this.delegate.getValueType();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setTypes(Class<K> keyType, Class<V> valueType) {
        this.checkIfReadOnly();
        this.delegate.setTypes(keyType, valueType);
        return this;
    }

    public Iterable<CacheEntryListenerConfiguration<K, V>> getCacheEntryListenerConfigurations() {
        return new UnmodifiableIterable<CacheEntryListenerConfiguration<K, V>>(this.delegate.getCacheEntryListenerConfigurations());
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> addCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.checkIfReadOnly();
        this.delegate.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        return this;
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> removeCacheEntryListenerConfiguration(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.checkIfReadOnly();
        this.delegate.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
        return this;
    }

    public @Nullable Factory<CacheLoader<K, V>> getCacheLoaderFactory() {
        return this.delegate.getCacheLoaderFactory();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setCacheLoaderFactory(@Nullable Factory<? extends CacheLoader<K, V>> factory) {
        this.checkIfReadOnly();
        this.delegate.setCacheLoaderFactory(factory);
        return this;
    }

    public @Nullable Factory<CacheWriter<? super K, ? super V>> getCacheWriterFactory() {
        return this.delegate.getCacheWriterFactory();
    }

    public @Nullable CacheWriter<K, V> getCacheWriter() {
        Factory factory = this.delegate.getCacheWriterFactory();
        if (factory != null) {
            CacheWriter writer = (CacheWriter)factory.create();
            return writer;
        }
        return null;
    }

    public boolean hasCacheWriter() {
        return this.getCacheWriterFactory() != null;
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setCacheWriterFactory(@Nullable Factory<? extends CacheWriter<? super K, ? super V>> factory) {
        this.checkIfReadOnly();
        this.delegate.setCacheWriterFactory(factory);
        return this;
    }

    public Factory<ExpiryPolicy> getExpiryPolicyFactory() {
        return this.delegate.getExpiryPolicyFactory();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setExpiryPolicyFactory(@Nullable Factory<? extends ExpiryPolicy> factory) {
        this.checkIfReadOnly();
        this.delegate.setExpiryPolicyFactory(factory);
        return this;
    }

    public boolean isReadThrough() {
        return this.delegate.isReadThrough();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setReadThrough(boolean isReadThrough) {
        this.checkIfReadOnly();
        this.delegate.setReadThrough(isReadThrough);
        return this;
    }

    public boolean isWriteThrough() {
        return this.delegate.isWriteThrough();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setWriteThrough(boolean isWriteThrough) {
        this.checkIfReadOnly();
        this.delegate.setWriteThrough(isWriteThrough);
        return this;
    }

    public boolean isStoreByValue() {
        return this.delegate.isStoreByValue();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setStoreByValue(boolean isStoreByValue) {
        this.checkIfReadOnly();
        this.delegate.setStoreByValue(isStoreByValue);
        return this;
    }

    public boolean isNativeStatisticsEnabled() {
        return this.nativeStatistics;
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setNativeStatisticsEnabled(boolean enabled) {
        this.checkIfReadOnly();
        this.nativeStatistics = enabled;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.delegate.isStatisticsEnabled();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setStatisticsEnabled(boolean enabled) {
        this.checkIfReadOnly();
        this.delegate.setStatisticsEnabled(enabled);
        return this;
    }

    public boolean isManagementEnabled() {
        return this.delegate.isManagementEnabled();
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setManagementEnabled(boolean enabled) {
        this.checkIfReadOnly();
        this.delegate.setManagementEnabled(enabled);
        return this;
    }

    public Factory<Copier> getCopierFactory() {
        return this.copierFactory;
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setCopierFactory(Factory<Copier> factory) {
        this.checkIfReadOnly();
        this.copierFactory = Objects.requireNonNull(factory);
        return this;
    }

    public Factory<Scheduler> getSchedulerFactory() {
        return this.schedulerFactory;
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setSchedulerFactory(Factory<Scheduler> factory) {
        this.checkIfReadOnly();
        this.schedulerFactory = Objects.requireNonNull(factory);
        return this;
    }

    public Factory<Ticker> getTickerFactory() {
        return this.tickerFactory;
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setTickerFactory(Factory<Ticker> factory) {
        this.checkIfReadOnly();
        this.tickerFactory = Objects.requireNonNull(factory);
        return this;
    }

    public Factory<Executor> getExecutorFactory() {
        return this.executorFactory;
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setExecutorFactory(Factory<Executor> factory) {
        this.checkIfReadOnly();
        this.executorFactory = Objects.requireNonNull(factory);
        return this;
    }

    public OptionalLong getRefreshAfterWrite() {
        return this.refreshAfterWriteNanos == null ? OptionalLong.empty() : OptionalLong.of(this.refreshAfterWriteNanos);
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setRefreshAfterWrite(OptionalLong refreshAfterWriteNanos) {
        this.checkIfReadOnly();
        this.refreshAfterWriteNanos = refreshAfterWriteNanos.isPresent() ? Long.valueOf(refreshAfterWriteNanos.getAsLong()) : null;
        return this;
    }

    public OptionalLong getExpireAfterWrite() {
        return this.expireAfterWriteNanos == null ? OptionalLong.empty() : OptionalLong.of(this.expireAfterWriteNanos);
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setExpireAfterWrite(OptionalLong expireAfterWriteNanos) {
        this.checkIfReadOnly();
        this.expireAfterWriteNanos = expireAfterWriteNanos.isPresent() ? Long.valueOf(expireAfterWriteNanos.getAsLong()) : null;
        return this;
    }

    public OptionalLong getExpireAfterAccess() {
        return this.expireAfterAccessNanos == null ? OptionalLong.empty() : OptionalLong.of(this.expireAfterAccessNanos);
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setExpireAfterAccess(OptionalLong expireAfterAccessNanos) {
        this.checkIfReadOnly();
        this.expireAfterAccessNanos = expireAfterAccessNanos.isPresent() ? Long.valueOf(expireAfterAccessNanos.getAsLong()) : null;
        return this;
    }

    public Optional<Factory<Expiry<K, V>>> getExpiryFactory() {
        return Optional.ofNullable(this.expiryFactory);
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setExpiryFactory(Optional<Factory<? extends Expiry<K, V>>> factory) {
        this.checkIfReadOnly();
        this.expiryFactory = factory.orElse(null);
        return this;
    }

    public OptionalLong getMaximumSize() {
        return this.maximumSize == null ? OptionalLong.empty() : OptionalLong.of(this.maximumSize);
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setMaximumSize(OptionalLong maximumSize) {
        this.checkIfReadOnly();
        this.maximumSize = maximumSize.isPresent() ? Long.valueOf(maximumSize.getAsLong()) : null;
        return this;
    }

    public OptionalLong getMaximumWeight() {
        return this.maximumWeight == null ? OptionalLong.empty() : OptionalLong.of(this.maximumWeight);
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setMaximumWeight(OptionalLong maximumWeight) {
        this.checkIfReadOnly();
        this.maximumWeight = maximumWeight.isPresent() ? Long.valueOf(maximumWeight.getAsLong()) : null;
        return this;
    }

    public Optional<Factory<Weigher<K, V>>> getWeigherFactory() {
        return Optional.ofNullable(this.weigherFactory);
    }

    @CanIgnoreReturnValue
    public CaffeineConfiguration<K, V> setWeigherFactory(Optional<Factory<? extends Weigher<K, V>>> factory) {
        this.checkIfReadOnly();
        this.weigherFactory = factory.orElse(null);
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CaffeineConfiguration)) {
            return false;
        }
        CaffeineConfiguration config = (CaffeineConfiguration)o;
        return Objects.equals(this.refreshAfterWriteNanos, config.refreshAfterWriteNanos) && Objects.equals(this.expireAfterAccessNanos, config.expireAfterAccessNanos) && Objects.equals(this.expireAfterWriteNanos, config.expireAfterWriteNanos) && Objects.equals(this.executorFactory, config.executorFactory) && Objects.equals(this.copierFactory, config.copierFactory) && Objects.equals(this.tickerFactory, config.tickerFactory) && Objects.equals(this.weigherFactory, config.weigherFactory) && Objects.equals(this.maximumWeight, config.maximumWeight) && Objects.equals(this.maximumSize, config.maximumSize) && this.delegate.equals(config.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    private static final class UnmodifiableIterable<E>
    implements Iterable<E> {
        private final Iterable<E> delegate;

        private UnmodifiableIterable(Iterable<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> iterator = this.delegate.iterator();
            return new Iterator<E>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public E next() {
                    return iterator.next();
                }
            };
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.delegate.spliterator();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

