/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.jcache.CacheProxy;
import com.github.benmanes.caffeine.jcache.Expirable;
import com.github.benmanes.caffeine.jcache.LoadingCacheProxy;
import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.github.benmanes.caffeine.jcache.configuration.TypesafeConfigurator;
import com.github.benmanes.caffeine.jcache.event.EventDispatcher;
import com.github.benmanes.caffeine.jcache.event.JCacheEvictionListener;
import com.github.benmanes.caffeine.jcache.integration.JCacheLoaderAdapter;
import com.github.benmanes.caffeine.jcache.management.JCacheStatisticsMXBean;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CacheFactory {
    private CacheFactory() {
    }

    public static boolean isDefinedExternally(CacheManager cacheManager, String cacheName) {
        return TypesafeConfigurator.cacheNames(CacheFactory.rootConfig(cacheManager)).contains(cacheName);
    }

    public static <K, V> @Nullable CacheProxy<K, V> tryToCreateFromExternalSettings(CacheManager cacheManager, String cacheName) {
        return TypesafeConfigurator.from(CacheFactory.rootConfig(cacheManager), cacheName).map(configuration -> CacheFactory.createCache(cacheManager, cacheName, configuration)).orElse(null);
    }

    public static <K, V> CacheProxy<K, V> createCache(CacheManager cacheManager, String cacheName, Configuration<K, V> configuration) {
        CaffeineConfiguration<K, V> config = CacheFactory.resolveConfigurationFor(cacheManager, configuration);
        return new Builder<K, V>(cacheManager, cacheName, config).build();
    }

    private static Config rootConfig(CacheManager cacheManager) {
        return Objects.requireNonNull(TypesafeConfigurator.configSource().get(cacheManager.getURI(), cacheManager.getClassLoader()));
    }

    private static <K, V> CaffeineConfiguration<K, V> resolveConfigurationFor(CacheManager cacheManager, Configuration<K, V> configuration) {
        if (configuration instanceof CaffeineConfiguration) {
            return new CaffeineConfiguration((CaffeineConfiguration)configuration);
        }
        CaffeineConfiguration template = TypesafeConfigurator.defaults(CacheFactory.rootConfig(cacheManager));
        if (configuration instanceof CompleteConfiguration) {
            CompleteConfiguration complete = (CompleteConfiguration)configuration;
            template.setReadThrough(complete.isReadThrough());
            template.setWriteThrough(complete.isWriteThrough());
            template.setManagementEnabled(complete.isManagementEnabled());
            template.setStatisticsEnabled(complete.isStatisticsEnabled());
            template.getCacheEntryListenerConfigurations().forEach(template::removeCacheEntryListenerConfiguration);
            complete.getCacheEntryListenerConfigurations().forEach(template::addCacheEntryListenerConfiguration);
            template.setCacheLoaderFactory(complete.getCacheLoaderFactory());
            template.setCacheWriterFactory(complete.getCacheWriterFactory());
            template.setExpiryPolicyFactory((Factory<ExpiryPolicy>)complete.getExpiryPolicyFactory());
        }
        template.setTypes(configuration.getKeyType(), configuration.getValueType());
        template.setStoreByValue(configuration.isStoreByValue());
        return template;
    }

    private static final class ExpirableToExpiry<K, V>
    implements Expiry<K, Expirable<V>> {
        private final Ticker ticker;

        public ExpirableToExpiry(Ticker ticker) {
            this.ticker = Objects.requireNonNull(ticker);
        }

        public long expireAfterCreate(K key, Expirable<V> expirable, long currentTime) {
            return this.toNanos(expirable);
        }

        public long expireAfterUpdate(K key, Expirable<V> expirable, long currentTime, long currentDuration) {
            return this.toNanos(expirable);
        }

        public long expireAfterRead(K key, Expirable<V> expirable, long currentTime, long currentDuration) {
            return this.toNanos(expirable);
        }

        private long toNanos(Expirable<V> expirable) {
            if (expirable.getExpireTimeMS() == 0L) {
                return -1L;
            }
            if (expirable.isEternal()) {
                return Long.MAX_VALUE;
            }
            return TimeUnit.MILLISECONDS.toNanos(expirable.getExpireTimeMS()) - this.ticker.read();
        }
    }

    private static final class ExpiryAdapter<K, V>
    implements Expiry<K, Expirable<V>> {
        private final Expiry<K, V> expiry;

        public ExpiryAdapter(Expiry<K, V> expiry) {
            this.expiry = Objects.requireNonNull(expiry);
        }

        public long expireAfterCreate(K key, Expirable<V> expirable, long currentTime) {
            return this.expiry.expireAfterCreate(key, expirable.get(), currentTime);
        }

        public long expireAfterUpdate(K key, Expirable<V> expirable, long currentTime, long currentDuration) {
            return this.expiry.expireAfterUpdate(key, expirable.get(), currentTime, currentDuration);
        }

        public long expireAfterRead(K key, Expirable<V> expirable, long currentTime, long currentDuration) {
            return this.expiry.expireAfterRead(key, expirable.get(), currentTime, currentDuration);
        }
    }

    private static final class Builder<K, V> {
        final Ticker ticker;
        final String cacheName;
        final Executor executor;
        final Scheduler scheduler;
        final CacheManager cacheManager;
        final ExpiryPolicy expiryPolicy;
        final EventDispatcher<K, V> dispatcher;
        final JCacheStatisticsMXBean statistics;
        final Caffeine<Object, Object> caffeine;
        final CaffeineConfiguration<K, V> config;

        Builder(CacheManager cacheManager, String cacheName, CaffeineConfiguration<K, V> config) {
            this.config = config;
            this.cacheName = cacheName;
            this.cacheManager = cacheManager;
            this.caffeine = Caffeine.newBuilder();
            this.statistics = new JCacheStatisticsMXBean();
            this.ticker = (Ticker)config.getTickerFactory().create();
            this.executor = (Executor)config.getExecutorFactory().create();
            this.scheduler = (Scheduler)config.getSchedulerFactory().create();
            this.expiryPolicy = (ExpiryPolicy)config.getExpiryPolicyFactory().create();
            this.dispatcher = new EventDispatcher(this.executor);
            this.caffeine.ticker(this.ticker);
            this.caffeine.executor(this.executor);
            this.caffeine.scheduler(this.scheduler);
            config.getCacheEntryListenerConfigurations().forEach(this.dispatcher::register);
        }

        public CacheProxy<K, V> build() {
            CacheProxy<K, V> cache;
            boolean evicts = false;
            evicts |= this.configureMaximumSize();
            evicts |= this.configureMaximumWeight();
            boolean expires = false;
            expires |= this.configureExpireAfterWrite();
            expires |= this.configureExpireAfterAccess();
            if (!(expires |= this.configureExpireVariably())) {
                expires = this.configureJCacheExpiry();
            }
            if (this.config.isNativeStatisticsEnabled()) {
                this.caffeine.recordStats();
            }
            JCacheEvictionListener<K, V> evictionListener = null;
            if (evicts || expires) {
                evictionListener = new JCacheEvictionListener<K, V>(this.dispatcher, this.statistics);
                this.caffeine.evictionListener(evictionListener);
            }
            if (this.isReadThrough()) {
                this.configureRefreshAfterWrite();
                cache = this.newLoadingCacheProxy();
            } else {
                cache = this.newCacheProxy();
            }
            if (evictionListener != null) {
                evictionListener.setCache(cache);
            }
            return cache;
        }

        private boolean isReadThrough() {
            return this.config.isReadThrough() && this.config.getCacheLoaderFactory() != null;
        }

        private CacheProxy<K, V> newCacheProxy() {
            Optional cacheLoader = Optional.ofNullable(this.config.getCacheLoaderFactory()).map(Factory::create);
            return new CacheProxy<K, V>(this.cacheName, this.executor, this.cacheManager, this.config, this.caffeine.build(), this.dispatcher, cacheLoader, this.expiryPolicy, this.ticker, this.statistics);
        }

        private CacheProxy<K, V> newLoadingCacheProxy() {
            CacheLoader cacheLoader = (CacheLoader)this.config.getCacheLoaderFactory().create();
            JCacheLoaderAdapter<K, V> adapter = new JCacheLoaderAdapter<K, V>(cacheLoader, this.dispatcher, this.expiryPolicy, this.ticker, this.statistics);
            LoadingCacheProxy<K, V> cache = new LoadingCacheProxy<K, V>(this.cacheName, this.executor, this.cacheManager, this.config, this.caffeine.build(adapter), this.dispatcher, cacheLoader, this.expiryPolicy, this.ticker, this.statistics);
            adapter.setCache(cache);
            return cache;
        }

        private boolean configureMaximumSize() {
            if (this.config.getMaximumSize().isPresent()) {
                this.caffeine.maximumSize(this.config.getMaximumSize().getAsLong());
            }
            return this.config.getMaximumSize().isPresent();
        }

        private boolean configureMaximumWeight() {
            if (this.config.getMaximumWeight().isPresent()) {
                this.caffeine.maximumWeight(this.config.getMaximumWeight().getAsLong());
                Weigher weigher = this.config.getWeigherFactory().map(Factory::create).orElseThrow(() -> new IllegalStateException("Weigher not configured"));
                this.caffeine.weigher((key, expirable) -> weigher.weigh(key, expirable.get()));
            }
            return this.config.getMaximumWeight().isPresent();
        }

        private boolean configureExpireAfterWrite() {
            if (this.config.getExpireAfterWrite().isEmpty()) {
                return false;
            }
            this.caffeine.expireAfterWrite(this.config.getExpireAfterWrite().getAsLong(), TimeUnit.NANOSECONDS);
            return true;
        }

        private boolean configureExpireAfterAccess() {
            if (this.config.getExpireAfterAccess().isEmpty()) {
                return false;
            }
            this.caffeine.expireAfterAccess(this.config.getExpireAfterAccess().getAsLong(), TimeUnit.NANOSECONDS);
            return true;
        }

        private boolean configureExpireVariably() {
            if (this.config.getExpiryFactory().isEmpty()) {
                return false;
            }
            this.caffeine.expireAfter(new ExpiryAdapter((Expiry)this.config.getExpiryFactory().orElseThrow().create()));
            return true;
        }

        private boolean configureJCacheExpiry() {
            if (this.expiryPolicy instanceof EternalExpiryPolicy) {
                return false;
            }
            this.caffeine.expireAfter(new ExpirableToExpiry(this.ticker));
            return true;
        }

        private void configureRefreshAfterWrite() {
            if (this.config.getRefreshAfterWrite().isPresent()) {
                this.caffeine.refreshAfterWrite(this.config.getRefreshAfterWrite().getAsLong(), TimeUnit.NANOSECONDS);
            }
        }
    }
}

