/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.event;

import com.github.benmanes.caffeine.jcache.event.EventTypeAwareListener;
import com.github.benmanes.caffeine.jcache.event.EventTypeFilter;
import com.github.benmanes.caffeine.jcache.event.JCacheEntryEvent;
import com.github.benmanes.caffeine.jcache.event.Registration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.EventType;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EventDispatcher<K, V> {
    static final Logger logger = Logger.getLogger(EventDispatcher.class.getName());
    static final ThreadLocal<List<CompletableFuture<Void>>> pending = ThreadLocal.withInitial(ArrayList::new);
    final Executor executor;
    final Map<Registration<K, V>, CompletableFuture<Void>> dispatchQueues = new ConcurrentHashMap<Registration<K, V>, CompletableFuture<Void>>();

    public EventDispatcher(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
    }

    public Set<Registration<K, V>> registrations() {
        return Collections.unmodifiableSet(this.dispatchQueues.keySet());
    }

    public void register(CacheEntryListenerConfiguration<K, V> configuration) {
        if (configuration.getCacheEntryListenerFactory() == null) {
            return;
        }
        EventTypeAwareListener listener = new EventTypeAwareListener((CacheEntryListener)configuration.getCacheEntryListenerFactory().create());
        EventTypeFilter filter = event -> true;
        if (configuration.getCacheEntryEventFilterFactory() != null) {
            filter = new EventTypeFilter(listener, (CacheEntryEventFilter)configuration.getCacheEntryEventFilterFactory().create());
        }
        Registration<K, V> registration = new Registration<K, V>(configuration, filter, listener);
        this.dispatchQueues.putIfAbsent(registration, CompletableFuture.completedFuture(null));
    }

    public void deregister(CacheEntryListenerConfiguration<K, V> configuration) {
        Objects.requireNonNull(configuration);
        this.dispatchQueues.keySet().removeIf(registration -> configuration.equals(registration.getConfiguration()));
    }

    public void publishCreated(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.CREATED, key, null, value, false);
    }

    public void publishUpdated(Cache<K, V> cache, K key, V oldValue, V newValue) {
        this.publish(cache, EventType.UPDATED, key, oldValue, newValue, false);
    }

    public void publishRemoved(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.REMOVED, key, null, value, false);
    }

    public void publishRemovedQuietly(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.REMOVED, key, null, value, true);
    }

    public void publishExpired(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.EXPIRED, key, value, null, false);
    }

    public void publishExpiredQuietly(Cache<K, V> cache, K key, V value) {
        this.publish(cache, EventType.EXPIRED, key, value, null, true);
    }

    public void awaitSynchronous() {
        List<CompletableFuture<Void>> futures = pending.get();
        if (futures.isEmpty()) {
            return;
        }
        try {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).join();
        }
        catch (CompletionException e) {
            logger.log(Level.WARNING, null, e);
        }
        finally {
            futures.clear();
        }
    }

    public void ignoreSynchronous() {
        pending.get().clear();
    }

    private void publish(Cache<K, V> cache, EventType eventType, K key, @Nullable V oldValue, @Nullable V newValue, boolean quiet) {
        if (this.dispatchQueues.isEmpty()) {
            return;
        }
        JCacheEntryEvent<K, V> event = null;
        for (Registration<K, V> registration : this.dispatchQueues.keySet()) {
            JCacheEntryEvent<K, V> e;
            CompletableFuture future;
            if (!registration.getCacheEntryListener().isCompatible(eventType)) continue;
            if (event == null) {
                event = new JCacheEntryEvent<K, V>(cache, eventType, key, oldValue, newValue);
            }
            if (!registration.getCacheEntryFilter().evaluate(event) || (future = this.dispatchQueues.computeIfPresent(registration, (arg_0, arg_1) -> this.lambda$publish$3(registration, e = event, arg_0, arg_1))) == null || !registration.isSynchronous() || quiet) continue;
            pending.get().add(future);
        }
    }

    private /* synthetic */ CompletableFuture lambda$publish$3(Registration registration, JCacheEntryEvent e, Registration k, CompletableFuture queue) {
        Runnable action = () -> registration.getCacheEntryListener().dispatch(e);
        return queue.thenRunAsync(action, this.executor);
    }
}

