/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.configuration;

import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.github.benmanes.caffeine.jcache.configuration.FactoryCreator;
import com.github.benmanes.caffeine.jcache.expiry.JCacheExpiryPolicy;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableCacheEntryListenerConfiguration;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.inject.Inject;

public final class TypesafeConfigurator {
    static final Logger logger = Logger.getLogger(TypesafeConfigurator.class.getName());
    static FactoryCreator factoryCreator = FactoryBuilder::factoryOf;

    private TypesafeConfigurator() {
    }

    public static <K, V> CaffeineConfiguration<K, V> defaults(Config config) {
        return new Configurator(config, "default").configure();
    }

    public static <K, V> Optional<CaffeineConfiguration<K, V>> from(Config config, String cacheName) {
        CaffeineConfiguration configuration = null;
        try {
            if (config.hasPath("caffeine.jcache." + cacheName)) {
                configuration = new Configurator(config, cacheName).configure();
            }
        }
        catch (ConfigException.BadPath e) {
            logger.log(Level.WARNING, "Failed to load cache configuration", e);
        }
        return Optional.ofNullable(configuration);
    }

    @Inject
    public static void setFactoryCreator(FactoryCreator factoryCreator) {
        TypesafeConfigurator.factoryCreator = Objects.requireNonNull(factoryCreator);
    }

    private static final class Configurator<K, V> {
        final CaffeineConfiguration<K, V> configuration;
        final Config rootConfig;
        final Config config;

        Configurator(Config config, String cacheName) {
            this.rootConfig = Objects.requireNonNull(config);
            this.configuration = new CaffeineConfiguration();
            this.config = this.rootConfig.getConfig("caffeine.jcache." + cacheName).withFallback((ConfigMergeable)this.rootConfig.getConfig("caffeine.jcache.default"));
        }

        CaffeineConfiguration<K, V> configure() {
            this.addStoreByValue();
            this.addListeners();
            this.addReadThrough();
            this.addWriteThrough();
            this.addMonitoring();
            this.addLazyExpiration();
            this.addEagerExpiration();
            this.addRefresh();
            this.addMaximum();
            return this.configuration;
        }

        private void addStoreByValue() {
            boolean enabled = this.config.getBoolean("store-by-value.enabled");
            this.configuration.setStoreByValue(enabled);
            if (this.config.hasPath("store-by-value.strategy")) {
                this.configuration.setCopierFactory(factoryCreator.factoryOf(this.config.getString("store-by-value.strategy")));
            }
        }

        private void addListeners() {
            for (String path : this.config.getStringList("listeners")) {
                Config listener = this.rootConfig.getConfig(path);
                Factory listenerFactory = factoryCreator.factoryOf(listener.getString("class"));
                Factory filterFactory = null;
                if (listener.hasPath("filter")) {
                    filterFactory = factoryCreator.factoryOf(listener.getString("filter"));
                }
                boolean oldValueRequired = listener.getBoolean("old-value-required");
                boolean synchronous = listener.getBoolean("synchronous");
                this.configuration.addCacheEntryListenerConfiguration((CacheEntryListenerConfiguration<K, V>)new MutableCacheEntryListenerConfiguration(listenerFactory, filterFactory, oldValueRequired, synchronous));
            }
        }

        private void addReadThrough() {
            boolean isReadThrough = this.config.getBoolean("read-through.enabled");
            this.configuration.setReadThrough(isReadThrough);
            if (this.config.hasPath("read-through.loader")) {
                String loaderClass = this.config.getString("read-through.loader");
                this.configuration.setCacheLoaderFactory(factoryCreator.factoryOf(loaderClass));
            }
        }

        private void addWriteThrough() {
            boolean isWriteThrough = this.config.getBoolean("write-through.enabled");
            this.configuration.setWriteThrough(isWriteThrough);
            if (this.config.hasPath("write-through.writer")) {
                String writerClass = this.config.getString("write-through.writer");
                this.configuration.setCacheWriterFactory(factoryCreator.factoryOf(writerClass));
            }
        }

        private void addMonitoring() {
            this.configuration.setStatisticsEnabled(this.config.getBoolean("monitoring.statistics"));
            this.configuration.setManagementEnabled(this.config.getBoolean("monitoring.management"));
        }

        public void addLazyExpiration() {
            Duration creation = this.getDurationFor("policy.lazy-expiration.creation");
            Duration update = this.getDurationFor("policy.lazy-expiration.update");
            Duration access = this.getDurationFor("policy.lazy-expiration.access");
            boolean eternal = Objects.equals(creation, Duration.ETERNAL) && Objects.equals(update, Duration.ETERNAL) && Objects.equals(access, Duration.ETERNAL);
            Factory factory = eternal ? EternalExpiryPolicy.factoryOf() : FactoryBuilder.factoryOf((Serializable)new JCacheExpiryPolicy(creation, update, access));
            this.configuration.setExpiryPolicyFactory((Factory<ExpiryPolicy>)factory);
        }

        @Nullable
        private Duration getDurationFor(String path) {
            if (!this.config.hasPath(path)) {
                return null;
            }
            if (this.config.getString(path).equalsIgnoreCase("eternal")) {
                return Duration.ETERNAL;
            }
            long millis = this.config.getDuration(path, TimeUnit.MILLISECONDS);
            return new Duration(TimeUnit.MILLISECONDS, millis);
        }

        public void addEagerExpiration() {
            long nanos;
            Config expiration = this.config.getConfig("policy.eager-expiration");
            if (expiration.hasPath("after-write")) {
                nanos = expiration.getDuration("after-write", TimeUnit.NANOSECONDS);
                this.configuration.setExpireAfterWrite(OptionalLong.of(nanos));
            }
            if (expiration.hasPath("after-access")) {
                nanos = expiration.getDuration("after-access", TimeUnit.NANOSECONDS);
                this.configuration.setExpireAfterAccess(OptionalLong.of(nanos));
            }
            if (expiration.hasPath("variable")) {
                this.configuration.setExpiryFactory(Optional.of(FactoryBuilder.factoryOf((String)expiration.getString("variable"))));
            }
        }

        public void addRefresh() {
            Config refresh = this.config.getConfig("policy.refresh");
            if (refresh.hasPath("after-write")) {
                long nanos = refresh.getDuration("after-write", TimeUnit.NANOSECONDS);
                this.configuration.setRefreshAfterWrite(OptionalLong.of(nanos));
            }
        }

        private void addMaximum() {
            Config maximum = this.config.getConfig("policy.maximum");
            if (maximum.hasPath("size")) {
                this.configuration.setMaximumSize(OptionalLong.of(maximum.getLong("size")));
            }
            if (maximum.hasPath("weight")) {
                this.configuration.setMaximumWeight(OptionalLong.of(maximum.getLong("weight")));
            }
            if (maximum.hasPath("weigher")) {
                this.configuration.setWeigherFactory(FactoryBuilder.factoryOf((String)maximum.getString("weigher")));
            }
        }
    }
}

