/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.spi;

import com.github.benmanes.caffeine.jcache.CacheManagerImpl;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.cache.CacheManager;
import javax.cache.configuration.OptionalFeature;
import javax.cache.spi.CachingProvider;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@NullMarked
@Component
public final class CaffeineCachingProvider
implements CachingProvider {
    private static final ClassLoader DEFAULT_CLASS_LOADER = new JCacheClassLoader(Thread.currentThread().getContextClassLoader());
    @GuardedBy(value="itself")
    final Map<ClassLoader, Map<URI, CacheManager>> cacheManagers = new WeakHashMap<ClassLoader, Map<URI, CacheManager>>(1);
    boolean isOsgiComponent;

    public ClassLoader getDefaultClassLoader() {
        return DEFAULT_CLASS_LOADER;
    }

    public URI getDefaultURI() {
        return URI.create(this.getClass().getName());
    }

    public Properties getDefaultProperties() {
        return new Properties();
    }

    public CacheManager getCacheManager() {
        return this.getCacheManager(this.getDefaultURI(), this.getDefaultClassLoader());
    }

    public CacheManager getCacheManager(URI uri, ClassLoader classLoader) {
        return this.getCacheManager(uri, classLoader, this.getDefaultProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheManager getCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        URI managerUri = this.getManagerUri(uri);
        ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            Map cacheManagersByUri = this.cacheManagers.computeIfAbsent(managerClassLoader, any -> new HashMap());
            return cacheManagersByUri.computeIfAbsent(managerUri, any -> {
                Properties managerProperties = properties == null ? this.getDefaultProperties() : properties;
                return new CacheManagerImpl(this, this.isOsgiComponent, managerUri, managerClassLoader, managerProperties);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            for (ClassLoader classLoader : new ArrayList<ClassLoader>(this.cacheManagers.keySet())) {
                this.close(classLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
            Map<URI, CacheManager> cacheManagersByUri = this.cacheManagers.remove(managerClassLoader);
            if (cacheManagersByUri != null) {
                for (CacheManager cacheManager : cacheManagersByUri.values()) {
                    cacheManager.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(URI uri, ClassLoader classLoader) {
        Map<ClassLoader, Map<URI, CacheManager>> map = this.cacheManagers;
        synchronized (map) {
            ClassLoader managerClassLoader = this.getManagerClassLoader(classLoader);
            Map<URI, CacheManager> cacheManagersByUri = this.cacheManagers.get(managerClassLoader);
            if (cacheManagersByUri != null) {
                CacheManager cacheManager = cacheManagersByUri.remove(this.getManagerUri(uri));
                if (cacheManager != null) {
                    cacheManager.close();
                }
                if (cacheManagersByUri.isEmpty()) {
                    this.cacheManagers.remove(managerClassLoader);
                }
            }
        }
    }

    public boolean isSupported(OptionalFeature optionalFeature) {
        return optionalFeature == OptionalFeature.STORE_BY_REFERENCE;
    }

    private URI getManagerUri(URI uri) {
        return uri == null ? this.getDefaultURI() : uri;
    }

    private ClassLoader getManagerClassLoader(ClassLoader classLoader) {
        return classLoader == null ? this.getDefaultClassLoader() : classLoader;
    }

    @Activate
    private void activate() {
        this.isOsgiComponent = true;
    }

    static class JCacheClassLoader
    extends ClassLoader {
        public JCacheClassLoader(@Nullable ClassLoader parent) {
            super(parent);
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            ClassLoader parentClassLoader;
            ClassLoader classClassLoader;
            ClassNotFoundException error = null;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null && contextClassLoader != DEFAULT_CLASS_LOADER) {
                try {
                    return contextClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    error = e;
                }
            }
            if ((classClassLoader = this.getClassClassLoader()) != null && classClassLoader != contextClassLoader) {
                try {
                    return classClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    error = e;
                }
            }
            if ((parentClassLoader = this.getParent()) != null && parentClassLoader != classClassLoader && parentClassLoader != contextClassLoader) {
                try {
                    return parentClassLoader.loadClass(name);
                }
                catch (ClassNotFoundException e) {
                    error = e;
                }
            }
            throw error == null ? new ClassNotFoundException(name) : error;
        }

        @Override
        public @Nullable URL getResource(String name) {
            URL resource;
            URL resource2;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null && contextClassLoader != DEFAULT_CLASS_LOADER && (resource2 = contextClassLoader.getResource(name)) != null) {
                return resource2;
            }
            ClassLoader classClassLoader = this.getClassClassLoader();
            if (classClassLoader != null && classClassLoader != contextClassLoader && (resource = classClassLoader.getResource(name)) != null) {
                return resource;
            }
            ClassLoader parentClassLoader = this.getParent();
            if (parentClassLoader != null && parentClassLoader != classClassLoader && parentClassLoader != contextClassLoader) {
                return parentClassLoader.getResource(name);
            }
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            ClassLoader parentClassLoader;
            ClassLoader classClassLoader;
            ArrayList<URL> resources = new ArrayList<URL>();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null && contextClassLoader != DEFAULT_CLASS_LOADER) {
                resources.addAll(Collections.list(contextClassLoader.getResources(name)));
            }
            if ((classClassLoader = this.getClassClassLoader()) != null && classClassLoader != contextClassLoader) {
                resources.addAll(Collections.list(classClassLoader.getResources(name)));
            }
            if ((parentClassLoader = this.getParent()) != null && parentClassLoader != classClassLoader && parentClassLoader != contextClassLoader) {
                resources.addAll(Collections.list(parentClassLoader.getResources(name)));
            }
            return Collections.enumeration(resources);
        }

        @Nullable ClassLoader getClassClassLoader() {
            return this.getClass().getClassLoader();
        }
    }
}

