/*
 * Decompiled with CFR 0.152.
 */
package com.beeline09.daterangepicker.date;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.res.ResourcesCompat;
import com.beeline09.daterangepicker.R;
import com.google.android.material.textview.MaterialTextView;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\fJ\b\u0010\u0017\u001a\u00020\u0018H\u0017J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/beeline09/daterangepicker/date/TextViewWithCircularIndicator;", "Lcom/google/android/material/textview/MaterialTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "mCircleColor", "", "mCirclePaint", "Landroid/graphics/Paint;", "mDrawCircle", "", "mItemIsSelectedText", "", "mRadius", "createTextColor", "Landroid/content/res/ColorStateList;", "accentColor", "isDarkTheme", "drawIndicator", "", "drawCircle", "getContentDescription", "", "init", "onDraw", "canvas", "Landroid/graphics/Canvas;", "setAccentColor", "color", "Companion", "daterangepicker_release"})
public final class TextViewWithCircularIndicator
extends MaterialTextView {
    private Paint mCirclePaint;
    private final int mRadius;
    private int mCircleColor;
    private final String mItemIsSelectedText;
    private boolean mDrawCircle;
    private static final int SELECTED_CIRCLE_ALPHA = 255;
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    private final void init() {
        this.mCirclePaint.setFakeBoldText(true);
        this.mCirclePaint.setAntiAlias(true);
        this.mCirclePaint.setColor(this.mCircleColor);
        this.mCirclePaint.setTextAlign(Paint.Align.CENTER);
        this.mCirclePaint.setStyle(Paint.Style.FILL);
        this.mCirclePaint.setAlpha(SELECTED_CIRCLE_ALPHA);
    }

    public final void setAccentColor(int color2, boolean isDarkTheme) {
        this.mCircleColor = color2;
        this.mCirclePaint.setColor(this.mCircleColor);
        this.setTextColor(this.createTextColor(color2, isDarkTheme));
    }

    private final ColorStateList createTextColor(int accentColor) {
        int[][] states = new int[][]{{16842919}, {0x10100A1}, new int[0]};
        int[] colors = new int[]{accentColor, -1, -16777216};
        return new ColorStateList(states, colors);
    }

    private final ColorStateList createTextColor(int accentColor, boolean isDarkTheme) {
        int[] nArray;
        int[][] states = new int[][]{{16842919}, {0x10100A1}, new int[0]};
        if (isDarkTheme) {
            int[] nArray2 = new int[3];
            nArray2[0] = accentColor;
            nArray2[1] = -16777216;
            nArray = nArray2;
            nArray2[2] = -1;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = accentColor;
            nArray3[1] = -1;
            nArray = nArray3;
            nArray3[2] = -16777216;
        }
        int[] colors = nArray;
        return new ColorStateList(states, colors);
    }

    public final void drawIndicator(boolean drawCircle) {
        this.mDrawCircle = drawCircle;
    }

    public void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        if (this.mDrawCircle) {
            int width = this.getWidth();
            int height = this.getHeight();
            int radius = Math.min(width, height) / 2;
            canvas.drawCircle((float)(width / 2), (float)(height / 2), (float)radius, this.mCirclePaint);
        }
        this.setSelected(this.mDrawCircle);
        super.onDraw(canvas);
    }

    @SuppressLint(value={"GetContentDescriptionOverride"})
    @NotNull
    public CharSequence getContentDescription() {
        CharSequence charSequence;
        CharSequence itemText = this.getText();
        if (this.mDrawCircle) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = this.mItemIsSelectedText;
            Object[] objectArray = new Object[]{itemText};
            boolean bl = false;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
            charSequence = string3;
        } else {
            CharSequence charSequence2 = itemText;
            charSequence = charSequence2;
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence2, (String)"itemText");
        }
        return charSequence;
    }

    public TextViewWithCircularIndicator(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.mCirclePaint = new Paint();
        Resources res = context.getResources();
        this.mCircleColor = ResourcesCompat.getColor((Resources)res, (int)R.color.mdtp_accent_color, (Resources.Theme)context.getTheme());
        this.mRadius = res.getDimensionPixelOffset(R.dimen.mdtp_month_select_circle_radius);
        String string2 = context.getResources().getString(R.string.mdtp_item_is_selected);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u2026ng.mdtp_item_is_selected)");
        this.mItemIsSelectedText = string2;
        this.init();
    }

    static {
        SELECTED_CIRCLE_ALPHA = 255;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/beeline09/daterangepicker/date/TextViewWithCircularIndicator$Companion;", "", "()V", "SELECTED_CIRCLE_ALPHA", "", "daterangepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

