/*
 * Decompiled with CFR 0.152.
 */
package fr.bipi.tressence.sentry;

import fr.bipi.tressence.base.FormatterPriorityTree;
import fr.bipi.tressence.common.filters.Filter;
import fr.bipi.tressence.common.filters.NoFilter;
import fr.bipi.tressence.common.formatter.DefaultLogFormatter;
import fr.bipi.tressence.common.formatter.Formatter;
import io.sentry.Sentry;
import io.sentry.event.Breadcrumb;
import io.sentry.event.BreadcrumbBuilder;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lfr/bipi/tressence/sentry/SentryBreadcrumbTree;", "Lfr/bipi/tressence/base/FormatterPriorityTree;", "priority", "", "filter", "Lfr/bipi/tressence/common/filters/Filter;", "formatter", "Lfr/bipi/tressence/common/formatter/Formatter;", "(ILfr/bipi/tressence/common/filters/Filter;Lfr/bipi/tressence/common/formatter/Formatter;)V", "fromAndroidLogPriorityToSentryLevel", "Lio/sentry/event/Breadcrumb$Level;", "log", "", "tag", "", "message", "t", "", "treessence_release"})
public final class SentryBreadcrumbTree
extends FormatterPriorityTree {
    @Override
    protected void log(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.skipLog(priority, tag, message, t)) {
            return;
        }
        BreadcrumbBuilder bb = new BreadcrumbBuilder();
        bb.setMessage(this.format(priority, tag, message)).setTimestamp(new Date()).setCategory("log").setType(Breadcrumb.Type.DEFAULT).setLevel(this.fromAndroidLogPriorityToSentryLevel(priority));
        Sentry.getContext().recordBreadcrumb(bb.build());
    }

    private final Breadcrumb.Level fromAndroidLogPriorityToSentryLevel(int priority) {
        Breadcrumb.Level level;
        switch (priority) {
            case 4: {
                level = Breadcrumb.Level.INFO;
                break;
            }
            case 5: {
                level = Breadcrumb.Level.WARNING;
                break;
            }
            case 6: {
                level = Breadcrumb.Level.ERROR;
                break;
            }
            case 7: {
                level = Breadcrumb.Level.CRITICAL;
                break;
            }
            case 2: 
            case 3: {
                level = Breadcrumb.Level.DEBUG;
                break;
            }
            default: {
                level = Breadcrumb.Level.DEBUG;
            }
        }
        return level;
    }

    @JvmOverloads
    public SentryBreadcrumbTree(int priority, @NotNull Filter filter2, @NotNull Formatter formatter2) {
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)formatter2, (String)"formatter");
        super(priority, filter2, formatter2);
    }

    public /* synthetic */ SentryBreadcrumbTree(int n, Filter filter2, Formatter formatter2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            filter2 = NoFilter.Companion.getINSTANCE();
        }
        if ((n2 & 4) != 0) {
            formatter2 = DefaultLogFormatter.Companion.getINSTANCE();
        }
        this(n, filter2, formatter2);
    }

    @JvmOverloads
    public SentryBreadcrumbTree(int priority, @NotNull Filter filter2) {
        this(priority, filter2, null, 4, null);
    }

    @JvmOverloads
    public SentryBreadcrumbTree(int priority) {
        this(priority, null, null, 6, null);
    }
}

