/*
 * Decompiled with CFR 0.152.
 */
package fr.bipi.tressence.file;

import fr.bipi.tressence.base.FormatterPriorityTree;
import fr.bipi.tressence.base.NoTree;
import fr.bipi.tressence.common.filters.Filter;
import fr.bipi.tressence.common.filters.NoFilter;
import fr.bipi.tressence.common.formatter.Formatter;
import fr.bipi.tressence.common.formatter.LogcatFormatter;
import fr.bipi.tressence.common.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0004 !\"#BE\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\tH\u0002J\u000e\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\tJ,\u0010\u001b\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lfr/bipi/tressence/file/FileLoggerTree;", "Lfr/bipi/tressence/base/FormatterPriorityTree;", "logger", "Ljava/util/logging/Logger;", "fileHandler", "Ljava/util/logging/FileHandler;", "path", "", "nbFiles", "", "priority", "filter", "Lfr/bipi/tressence/common/filters/Filter;", "formatter", "Lfr/bipi/tressence/common/formatter/Formatter;", "(Ljava/util/logging/Logger;Ljava/util/logging/FileHandler;Ljava/lang/String;IILfr/bipi/tressence/common/filters/Filter;Lfr/bipi/tressence/common/formatter/Formatter;)V", "files", "", "Ljava/io/File;", "getFiles", "()Ljava/util/Collection;", "clear", "", "fromPriorityToLevel", "Ljava/util/logging/Level;", "getFileName", "i", "log", "tag", "message", "t", "", "Builder", "Companion", "MyLogger", "NoFormatter", "treessence_release"})
public final class FileLoggerTree
extends FormatterPriorityTree {
    private final Logger logger;
    private final FileHandler fileHandler;
    private final String path;
    private final int nbFiles;
    private static final String TAG = "FileLoggerTree";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    protected void log(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.skipLog(priority, tag, message, t)) {
            return;
        }
        this.logger.log(this.fromPriorityToLevel(priority), this.format(priority, tag, message));
        if (t != null) {
            this.logger.log(this.fromPriorityToLevel(priority), "", t);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        FileHandler fileHandler = this.fileHandler;
        if (fileHandler != null) {
            fileHandler.close();
        }
        int n = 0;
        int n2 = this.nbFiles;
        while (n < n2) {
            void i;
            File f = new File(this.getFileName((int)i));
            if (f.exists() && f.isFile()) {
                f.delete();
            }
            ++i;
        }
    }

    @NotNull
    public final String getFileName(int i) {
        return !StringsKt.contains$default((CharSequence)this.path, (CharSequence)"%g", (boolean)false, (int)2, null) ? this.path + "." + i : StringsKt.replace$default((String)this.path, (String)"%g", (String)("" + i), (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<File> getFiles() {
        Collection col = new ArrayList(this.nbFiles);
        int n = 0;
        int n2 = this.nbFiles;
        while (n < n2) {
            void i;
            File f = new File(this.getFileName((int)i));
            if (f.exists()) {
                col.add(f);
            }
            ++i;
        }
        return col;
    }

    private final Level fromPriorityToLevel(int priority) {
        Level level;
        switch (priority) {
            case 2: {
                Level level2 = Level.FINER;
                level = level2;
                Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"Level.FINER");
                break;
            }
            case 3: {
                Level level3 = Level.FINE;
                level = level3;
                Intrinsics.checkNotNullExpressionValue((Object)level3, (String)"Level.FINE");
                break;
            }
            case 4: {
                Level level4 = Level.INFO;
                level = level4;
                Intrinsics.checkNotNullExpressionValue((Object)level4, (String)"Level.INFO");
                break;
            }
            case 5: {
                Level level5 = Level.WARNING;
                level = level5;
                Intrinsics.checkNotNullExpressionValue((Object)level5, (String)"Level.WARNING");
                break;
            }
            case 6: {
                Level level6 = Level.SEVERE;
                level = level6;
                Intrinsics.checkNotNullExpressionValue((Object)level6, (String)"Level.SEVERE");
                break;
            }
            case 7: {
                Level level7 = Level.SEVERE;
                level = level7;
                Intrinsics.checkNotNullExpressionValue((Object)level7, (String)"Level.SEVERE");
                break;
            }
            default: {
                Level level8 = Level.FINEST;
                level = level8;
                Intrinsics.checkNotNullExpressionValue((Object)level8, (String)"Level.FINEST");
            }
        }
        return level;
    }

    @JvmOverloads
    public FileLoggerTree(@NotNull Logger logger, @Nullable FileHandler fileHandler, @NotNull String path, int nbFiles, int priority, @NotNull Filter filter2, @NotNull Formatter formatter2) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)formatter2, (String)"formatter");
        super(priority, filter2, formatter2);
        this.logger = logger;
        this.fileHandler = fileHandler;
        this.path = path;
        this.nbFiles = nbFiles;
    }

    public /* synthetic */ FileLoggerTree(Logger logger, FileHandler fileHandler, String string, int n, int n2, Filter filter2, Formatter formatter2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x20) != 0) {
            filter2 = NoFilter.Companion.getINSTANCE();
        }
        if ((n3 & 0x40) != 0) {
            formatter2 = LogcatFormatter.Companion.getINSTANCE();
        }
        this(logger, fileHandler, string, n, n2, filter2, formatter2);
    }

    @JvmOverloads
    public FileLoggerTree(@NotNull Logger logger, @Nullable FileHandler fileHandler, @NotNull String path, int nbFiles, int priority, @NotNull Filter filter2) {
        this(logger, fileHandler, path, nbFiles, priority, filter2, null, 64, null);
    }

    @JvmOverloads
    public FileLoggerTree(@NotNull Logger logger, @Nullable FileHandler fileHandler, @NotNull String path, int nbFiles, int priority) {
        this(logger, fileHandler, path, nbFiles, priority, null, null, 96, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0004J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0006J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lfr/bipi/tressence/file/FileLoggerTree$Builder;", "", "()V", "appendToFile", "", "dir", "", "fileLimit", "", "fileName", "filter", "Lfr/bipi/tressence/common/filters/Filter;", "formatter", "Lfr/bipi/tressence/common/formatter/Formatter;", "priority", "sizeLimit", "b", "build", "Lfr/bipi/tressence/file/FileLoggerTree;", "buildQuietly", "Ltimber/log/Timber$Tree;", "withDir", "d", "Ljava/io/File;", "withDirName", "dn", "withFileLimit", "f", "withFileName", "fn", "withFilter", "withFormatter", "withMinPriority", "p", "withSizeLimit", "nbBytes", "Companion", "treessence_release"})
    public static final class Builder {
        private String fileName = "log";
        private String dir = "";
        private int priority = 4;
        private int sizeLimit = 0x100000;
        private int fileLimit = 3;
        private boolean appendToFile = true;
        private Filter filter = NoFilter.Companion.getINSTANCE();
        private Formatter formatter = LogcatFormatter.Companion.getINSTANCE();
        public static final int SIZE_LIMIT = 0x100000;
        public static final int NB_FILE_LIMIT = 3;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final Builder withFileName(@NotNull String fn) {
            Intrinsics.checkNotNullParameter((Object)fn, (String)"fn");
            this.fileName = fn;
            return this;
        }

        @NotNull
        public final Builder withDirName(@NotNull String dn) {
            Intrinsics.checkNotNullParameter((Object)dn, (String)"dn");
            this.dir = dn;
            return this;
        }

        @NotNull
        public final Builder withDir(@NotNull File d) {
            Intrinsics.checkNotNullParameter((Object)d, (String)"d");
            String string = d.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"d.absolutePath");
            this.dir = string;
            return this;
        }

        @NotNull
        public final Builder withMinPriority(int p) {
            this.priority = p;
            return this;
        }

        @NotNull
        public final Builder withSizeLimit(int nbBytes) {
            this.sizeLimit = nbBytes;
            return this;
        }

        @NotNull
        public final Builder withFileLimit(int f) {
            this.fileLimit = f;
            return this;
        }

        @NotNull
        public final Builder withFilter(@NotNull Filter filter2) {
            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
            this.filter = filter2;
            return this;
        }

        @NotNull
        public final Builder withFormatter(@NotNull Formatter formatter2) {
            Intrinsics.checkNotNullParameter((Object)formatter2, (String)"formatter");
            this.formatter = formatter2;
            return this;
        }

        @NotNull
        public final Builder appendToFile(boolean b) {
            this.appendToFile = b;
            return this;
        }

        @NotNull
        public final FileLoggerTree build() throws IOException {
            File file = new File(this.dir);
            boolean bl = false;
            boolean bl2 = false;
            File $this$apply = file;
            boolean bl3 = false;
            if (!$this$apply.isDirectory()) {
                $this$apply.mkdirs();
            }
            String path = FileUtils.combinePath(this.dir, this.fileName);
            FileHandler fileHandler = null;
            Logger logger = MyLogger.Companion.getLogger(FileLoggerTree.TAG);
            logger.setLevel(Level.ALL);
            Handler[] handlerArray = logger.getHandlers();
            Intrinsics.checkNotNullExpressionValue((Object)handlerArray, (String)"logger.handlers");
            Handler[] handlerArray2 = handlerArray;
            boolean bl4 = false;
            if (handlerArray2.length == 0) {
                fileHandler = new FileHandler(path, this.sizeLimit, this.fileLimit, this.appendToFile);
                fileHandler.setFormatter(new NoFormatter());
                logger.addHandler(fileHandler);
            } else {
                Handler handler = logger.getHandlers()[0];
                if (handler == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.logging.FileHandler");
                }
                fileHandler = (FileHandler)handler;
            }
            String string = path;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
            return new FileLoggerTree(logger, fileHandler, string, this.fileLimit, this.priority, this.filter, this.formatter);
        }

        @NotNull
        public final Timber.Tree buildQuietly() {
            Timber.Tree tree;
            try {
                tree = (Timber.Tree)this.build();
            }
            catch (IOException e) {
                Timber.e((Throwable)e);
                tree = new NoTree();
            }
            return tree;
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lfr/bipi/tressence/file/FileLoggerTree$Builder$Companion;", "", "()V", "NB_FILE_LIMIT", "", "SIZE_LIMIT", "treessence_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lfr/bipi/tressence/file/FileLoggerTree$NoFormatter;", "Ljava/util/logging/Formatter;", "()V", "format", "", "record", "Ljava/util/logging/LogRecord;", "treessence_release"})
    private static final class NoFormatter
    extends java.util.logging.Formatter {
        @Override
        @NotNull
        public String format(@NotNull LogRecord record) {
            Intrinsics.checkNotNullParameter((Object)record, (String)"record");
            String string = record.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"record.message");
            return string;
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lfr/bipi/tressence/file/FileLoggerTree$MyLogger;", "Ljava/util/logging/Logger;", "name", "", "(Ljava/lang/String;)V", "Companion", "treessence_release"})
    private static final class MyLogger
    extends Logger {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public MyLogger(@Nullable String name) {
            super(name, null);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lfr/bipi/tressence/file/FileLoggerTree$MyLogger$Companion;", "", "()V", "getLogger", "Ljava/util/logging/Logger;", "name", "", "treessence_release"})
        public static final class Companion {
            @NotNull
            public final Logger getLogger(@Nullable String name) {
                return new MyLogger(name);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lfr/bipi/tressence/file/FileLoggerTree$Companion;", "", "()V", "TAG", "", "treessence_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

