/*
 * Decompiled with CFR 0.152.
 */
package fr.bipi.tressence.common.utils;

import java.lang.reflect.Method;
import timber.log.Timber;

public final class Info {
    private static final Method GET_ST;
    private static int sDepth;

    private Info() {
    }

    public static String getThreadInfoString() {
        Thread t = Thread.currentThread();
        return t + ", id : " + t.getId();
    }

    public static String getThreadFullInfoString() {
        Thread t = Thread.currentThread();
        StringBuilder sb = new StringBuilder();
        sb.append("Thread : ").append(t).append(", ").append("id : ").append(t.getId()).append(", ").append("state : ").append((Object)t.getState()).append(", ").append("alive : ").append(t.isAlive()).append(", ").append("interrupted : ").append(t.isInterrupted());
        return sb.toString();
    }

    public static String getMethodName() {
        return Info.getMethodName(sDepth);
    }

    public static String getMethodName(int depth) {
        try {
            StackTraceElement element = GET_ST != null ? (StackTraceElement)GET_ST.invoke((Object)new Throwable(), depth) : Info.getStackTraceElement(depth);
            if (element != null) {
                return element.getMethodName();
            }
            return "";
        }
        catch (Exception e) {
            Timber.e((String)e.toString(), (Object[])new Object[0]);
            return "";
        }
    }

    public static StackTraceElement getStackTraceElement(int depth) {
        return new Throwable().getStackTrace()[depth];
    }

    static {
        Method m = null;
        try {
            m = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            m.setAccessible(true);
            sDepth = 2;
        }
        catch (Exception ignore) {
            sDepth = 3;
        }
        finally {
            GET_ST = m;
        }
    }
}

