/*
 * Decompiled with CFR 0.152.
 */
package fr.bipi.tressence.common.time;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0011"}, d2={"Lfr/bipi/tressence/common/time/TimeStamper;", "", "format", "", "(Ljava/lang/String;)V", "tz", "Ljava/util/TimeZone;", "(Ljava/lang/String;Ljava/util/TimeZone;)V", "Ljava/text/SimpleDateFormat;", "(Ljava/text/SimpleDateFormat;)V", "dateFormat", "defaultTimeZone", "getDefaultTimeZone", "()Ljava/util/TimeZone;", "getCurrentTimeStamp", "milli", "", "treessence_release"})
public final class TimeStamper {
    private final SimpleDateFormat dateFormat;

    @NotNull
    public final TimeZone getDefaultTimeZone() {
        TimeZone.setDefault(null);
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"TimeZone.getDefault()");
        return timeZone;
    }

    @NotNull
    public final String getCurrentTimeStamp(long milli) {
        String string = this.dateFormat.format(new Date(milli));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dateFormat.format(Date(milli))");
        return string;
    }

    public TimeStamper(@NotNull String format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.dateFormat = new SimpleDateFormat(format, Locale.US);
        this.dateFormat.setTimeZone(this.getDefaultTimeZone());
    }

    public TimeStamper(@NotNull String format, @NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        this.dateFormat = new SimpleDateFormat(format, Locale.US);
        this.dateFormat.setTimeZone(tz);
    }

    public TimeStamper(@NotNull SimpleDateFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.dateFormat = format;
    }
}

