/*
 * Decompiled with CFR 0.152.
 */
package fr.bipi.tressence.common.filters;

import fr.bipi.tressence.common.filters.Filter;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016J,\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lfr/bipi/tressence/common/filters/TagFilter;", "Lfr/bipi/tressence/common/filters/Filter;", "tagRegex", "", "(Ljava/lang/String;)V", "pattern", "Ljava/util/regex/Pattern;", "(Ljava/util/regex/Pattern;)V", "getTagRegex", "()Ljava/lang/String;", "isLoggable", "", "priority", "", "tag", "skipLog", "message", "t", "", "treessence_release"})
public final class TagFilter
implements Filter {
    @NotNull
    private final String tagRegex;
    private final Pattern pattern;

    @NotNull
    public final String getTagRegex() {
        return this.tagRegex;
    }

    @Override
    public boolean skipLog(int priority, @Nullable String tag, @NotNull String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        String string = tag;
        if (string == null) {
            string = "";
        }
        return !this.pattern.matcher(string).matches();
    }

    @Override
    public boolean isLoggable(int priority, @Nullable String tag) {
        String string = tag;
        if (string == null) {
            string = "";
        }
        return this.pattern.matcher(string).matches();
    }

    public TagFilter(@NotNull String tagRegex) {
        Intrinsics.checkNotNullParameter((Object)tagRegex, (String)"tagRegex");
        this.tagRegex = tagRegex;
        Pattern pattern = Pattern.compile(tagRegex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"Pattern.compile(tagRegex)");
        this.pattern = pattern;
    }

    public TagFilter(@NotNull Pattern pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        this.pattern = pattern;
        String string = pattern.pattern();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern.pattern()");
        this.tagRegex = string;
    }
}

