/*
 * Decompiled with CFR 0.152.
 */
package uk.co.senab.photoview.gestures;

import android.annotation.TargetApi;
import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import uk.co.senab.photoview.gestures.EclairGestureDetector;

@TargetApi(value=8)
public class FroyoGestureDetector
extends EclairGestureDetector {
    protected final ScaleGestureDetector mDetector;

    public FroyoGestureDetector(Context context) {
        super(context);
        ScaleGestureDetector.OnScaleGestureListener mScaleListener = new ScaleGestureDetector.OnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                float scaleFactor = detector.getScaleFactor();
                if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
                    return false;
                }
                FroyoGestureDetector.this.mListener.onScale(scaleFactor, detector.getFocusX(), detector.getFocusY());
                return true;
            }

            public boolean onScaleBegin(ScaleGestureDetector detector) {
                FroyoGestureDetector.this.mListener.onScaleBegin(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY());
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector detector) {
                float scaleFactor = detector.getScaleFactor();
                if (Float.isNaN(scaleFactor) || Float.isInfinite(scaleFactor)) {
                    return;
                }
                FroyoGestureDetector.this.mListener.onScaleEnd(scaleFactor, detector.getFocusX(), detector.getFocusY());
            }
        };
        this.mDetector = new ScaleGestureDetector(context, mScaleListener);
    }

    @Override
    public boolean isScaling() {
        return this.mDetector.isInProgress();
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        try {
            this.mDetector.onTouchEvent(ev);
            return super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException e) {
            return true;
        }
    }
}

