/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager.adapter;

import android.content.Context;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.github.barteksc.pdfviewpager.R;
import com.github.barteksc.pdfviewpager.adapter.PDFPagerAdapter;
import java.lang.ref.WeakReference;
import uk.co.senab.photoview.PhotoViewAttacher;

public class PDFPagerAdapterZoom
extends PDFPagerAdapter {
    SparseArray<WeakReference<PhotoViewAttacher>> attachers = new SparseArray();

    public PDFPagerAdapterZoom(Context context, String pdfPath) {
        this(context, pdfPath, 1.0f);
    }

    public PDFPagerAdapterZoom(Context context, String pdfPath, float pageScale) {
        super(context, pdfPath, pageScale);
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        super.destroyItem(container, position, object);
        WeakReference attacherRef = (WeakReference)this.attachers.get(position);
        if (attacherRef != null) {
            PhotoViewAttacher attacher = (PhotoViewAttacher)attacherRef.get();
            if (attacher != null) {
                attacher.cleanup();
            }
            this.attachers.remove(position);
        }
    }

    @Override
    public Object instantiateItem(ViewGroup container, int position) {
        View v = this.inflater.inflate(R.layout.view_pdf_page, container, false);
        ImageView iv = (ImageView)v.findViewById(R.id.imageView);
        if (!this.pdfiumReady() || this.getCount() < position) {
            return v;
        }
        PhotoViewAttacher attacher = new PhotoViewAttacher(iv, this.pdfiumCore, this.pdfDocument, position, this.pageScale);
        this.attachers.put(position, new WeakReference<PhotoViewAttacher>(attacher));
        container.addView(v, 0);
        return v;
    }

    @Override
    public void close() {
        super.close();
        if (this.attachers != null) {
            this.attachers.clear();
            this.attachers = null;
        }
    }
}

