/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager.asset;

import android.content.Context;
import android.os.Handler;
import com.github.barteksc.pdfviewpager.asset.CopyAsset;
import com.github.barteksc.pdfviewpager.util.FileUtil;
import java.io.IOException;

public class CopyAssetThreadImpl
implements CopyAsset {
    Context context;
    Handler uiThread;
    CopyAsset.Listener listener = new NullListener();

    public CopyAssetThreadImpl(Context context, Handler uiThread, CopyAsset.Listener listener) {
        this.context = context;
        this.uiThread = uiThread;
        if (listener != null) {
            this.listener = listener;
        }
    }

    public CopyAssetThreadImpl(Context context, Handler uiThread) {
        this.context = context;
        this.uiThread = uiThread;
    }

    @Override
    public void copy(final String assetName, final String destinationPath) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    FileUtil.copyAsset(CopyAssetThreadImpl.this.context, assetName, destinationPath);
                    CopyAssetThreadImpl.this.notifySuccess(assetName, destinationPath);
                }
                catch (IOException e) {
                    CopyAssetThreadImpl.this.notifyError(e);
                }
            }
        }).start();
    }

    private void notifySuccess(final String assetName, final String destinationPath) {
        if (this.uiThread == null) {
            return;
        }
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                CopyAssetThreadImpl.this.listener.success(assetName, destinationPath);
            }
        });
    }

    private void notifyError(final IOException e) {
        if (this.uiThread == null) {
            return;
        }
        this.uiThread.post(new Runnable(){

            @Override
            public void run() {
                CopyAssetThreadImpl.this.listener.failure(e);
            }
        });
    }

    protected class NullListener
    implements CopyAsset.Listener {
        protected NullListener() {
        }

        @Override
        public void success(String assetName, String destinationPath) {
        }

        @Override
        public void failure(Exception e) {
        }
    }
}

