/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewpager;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.github.barteksc.pdfviewpager.R;
import com.github.barteksc.pdfviewpager.adapter.PDFPagerAdapter;
import fr.castorflex.android.verticalviewpager.VerticalViewPager;

public class PDFViewPager
extends VerticalViewPager {
    protected Context context;

    public PDFViewPager(Context context, String pdfPath) {
        super(context);
        this.context = context;
        this.init(pdfPath);
    }

    public PDFViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.init(attrs);
    }

    protected void init(String pdfPath) {
        this.initAdapter(this.context, pdfPath);
    }

    protected void init(AttributeSet attrs) {
        TypedArray a;
        String assetFileName;
        if (this.isInEditMode()) {
            this.setBackgroundResource(R.drawable.flaticon_pdf_dummy);
            return;
        }
        if (attrs != null && (assetFileName = (a = this.context.obtainStyledAttributes(attrs, R.styleable.PDFViewPager)).getString(R.styleable.PDFViewPager_assetFileName)) != null && assetFileName.length() > 0) {
            this.initAdapter(this.context, assetFileName);
        }
    }

    protected void initAdapter(Context context, String pdfPath) {
        this.setAdapter(new PDFPagerAdapter(context, pdfPath));
    }
}

