/*
 * Copyright (C) 2016 Bartosz Schiller.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.github.barteksc.pdfviewpager.view;

import android.content.Context;
import android.util.TypedValue;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.github.barteksc.pdfviewpager.util.Util;


public class ScrollBarPageIndicator extends RelativeLayout {

    protected TextView textView;
    protected Context context;
    private ScrollBar scrollBar;

    public ScrollBarPageIndicator(Context context) {
        super(context);
        this.context = context;
        textView = new TextView(context);
        setVisibility(INVISIBLE);
    }

    public void setSizeCustom(int size) {
        LayoutParams lp = (LayoutParams) getLayoutParams();
        lp.setMargins(0, 0, size + Util.getDP(getContext(), 10), 0);
        setLayoutParams(lp);
    }

    void linkToScrollBar(ScrollBar scrollBar) {

        LayoutParams lp = new LayoutParams(Util.getDP(getContext(), getIndicatorWidth()), Util.getDP(getContext(), getIndicatorHeight()));
        lp.setMargins(0, 0, Util.getDP(getContext(), 15) + scrollBar.getWidth(), 0);

        textView.setTextSize(TypedValue.COMPLEX_UNIT_DIP, getTextSize());
        LayoutParams tvlp = new LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        tvlp.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE);

        addView(textView, tvlp);

        //((GradientDrawable) getBackground()).setColor(scrollBar.handleColour);

        lp.addRule(ALIGN_RIGHT, scrollBar.getId());
        ((ViewGroup) scrollBar.getParent()).addView(this, lp);

        this.scrollBar = scrollBar;
    }

    /**
     * Used by the ScrollBar to move the indicator with the handle
     *
     * @param y Position to which the indicator should move.
     */
    void setScroll(float y) {
        if (getVisibility() == VISIBLE) {
            y -= Util.getDP(getContext(), getIndicatorHeight() / 2) - scrollBar.getHandlerHeight() / 2;

            if (y < 5) {
                y = 5;
            } else if (y > scrollBar.getHeight() - Util.getDP(getContext(), getIndicatorHeight())) {
                y = scrollBar.getHeight() - Util.getDP(getContext(), getIndicatorHeight());
            }

            setY(y);
        }
    }

    /**
     * Sets the content text for the indicator and resizes if needed
     */
    void setPageNum(int page) {
        String text = String.valueOf(page);
        if (!textView.getText().equals(text)) {
            textView.setText(text);
        }
    }

    /**
     * Used by the materialScrollBar to change the text colour for the indicator.
     *
     * @param color The desired text colour.
     */
    void setTextColor(int color) {
        textView.setTextColor(color);
    }

    int getIndicatorHeight() {
        return 75;
    }

    int getIndicatorWidth() {
        return 75;
    }

    int getTextSize() {
        return 40;
    }

}
