/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.utils;

import java.util.Locale;

public class OSUtils {
    private static final String WINDOWS = "windows";
    private static final String UNIX = "unix";
    private static final String MAC = "mac";
    private static final String OS = System.getProperty("os.name").toLowerCase(Locale.getDefault());

    public static String getOperatingSystem() {
        if (OSUtils.isWindows()) {
            return WINDOWS;
        }
        if (OSUtils.isUnix()) {
            return UNIX;
        }
        if (OSUtils.isMac()) {
            return MAC;
        }
        return null;
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains(MAC);
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }
}

