/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.testFramework.LightVirtualFileBase;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.utils.ApplicationUtils;

public class FileUtils {
    private static final OS os = System.getProperty("os.name").toLowerCase().contains("win") ? OS.WINDOWS : OS.UNIX;
    private static final String COLON_ENCODED = "%3A";
    public static final String SPACE_ENCODED = "%20";
    private static final String URI_FILE_BEGIN = "file:";
    private static final String URI_VALID_FILE_BEGIN = "file:///";
    private static final char URI_PATH_SEP = '/';
    private static Logger LOG = Logger.getInstance(FileUtils.class);

    public static String extFromPsiFile(PsiFile psiFile) {
        return psiFile.getVirtualFile().getExtension();
    }

    public static Editor editorFromPsiFile(PsiFile psiFile) {
        return FileUtils.editorFromVirtualFile(psiFile.getVirtualFile(), psiFile.getProject());
    }

    public static Editor editorFromUri(String uri, Project project) {
        return FileUtils.editorFromVirtualFile(FileUtils.virtualFileFromURI(uri), project);
    }

    public static Editor editorFromVirtualFile(VirtualFile file, Project project) {
        FileEditor[] allEditors = FileEditorManager.getInstance((Project)project).getAllEditors(file);
        if (allEditors.length > 0 && allEditors[0] instanceof TextEditor) {
            return ((TextEditor)allEditors[0]).getEditor();
        }
        return null;
    }

    public static VirtualFile virtualFileFromURI(String uri) {
        try {
            return LocalFileSystem.getInstance().findFileByIoFile(new File(new URI(FileUtils.sanitizeURI(uri))));
        }
        catch (URISyntaxException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public static FileType fileTypeFromEditor(Editor editor) {
        return FileDocumentManager.getInstance().getFile(editor.getDocument()).getFileType();
    }

    public static TextDocumentIdentifier editorToLSPIdentifier(Editor editor) {
        return new TextDocumentIdentifier(FileUtils.editorToURIString(editor));
    }

    public static String editorToURIString(Editor editor) {
        return FileUtils.sanitizeURI(FileUtils.VFSToURI(FileDocumentManager.getInstance().getFile(editor.getDocument())));
    }

    public static String VFSToURI(VirtualFile file) {
        try {
            return FileUtils.sanitizeURI(new URL(file.getUrl().replace(" ", SPACE_ENCODED)).toURI().toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public static String sanitizeURI(String uri) {
        if (uri != null) {
            StringBuilder reconstructed = new StringBuilder();
            String uriCp = uri.replaceAll(" ", SPACE_ENCODED);
            if (!uri.startsWith(URI_FILE_BEGIN)) {
                LOG.warn("Malformed uri : " + uri);
                return uri;
            }
            uriCp = uriCp.substring(URI_FILE_BEGIN.length());
            while (uriCp.startsWith(Character.toString('/'))) {
                uriCp = uriCp.substring(1);
            }
            reconstructed.append(URI_VALID_FILE_BEGIN);
            if (os == OS.UNIX) {
                return reconstructed.append(uriCp).toString();
            }
            reconstructed.append(uriCp.substring(0, uriCp.indexOf(47)));
            char driveLetter = reconstructed.charAt(URI_VALID_FILE_BEGIN.length());
            if (Character.isLowerCase(driveLetter)) {
                reconstructed.setCharAt(URI_VALID_FILE_BEGIN.length(), Character.toUpperCase(driveLetter));
            }
            if (reconstructed.toString().endsWith(COLON_ENCODED)) {
                reconstructed.delete(reconstructed.length() - 3, reconstructed.length());
            }
            if (!reconstructed.toString().endsWith(":")) {
                reconstructed.append(":");
            }
            return reconstructed.append(uriCp.substring(uriCp.indexOf(47))).toString();
        }
        return null;
    }

    public static VirtualFile URIToVFS(String uri) {
        try {
            return LocalFileSystem.getInstance().findFileByIoFile(new File(new URI(FileUtils.sanitizeURI(uri))));
        }
        catch (URISyntaxException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    public static String editorToProjectFolderUri(Editor editor) {
        return FileUtils.pathToUri(FileUtils.editorToProjectFolderPath(editor));
    }

    public static String editorToProjectFolderPath(Editor editor) {
        if (editor != null && editor.getProject() != null && editor.getProject().getBasePath() != null) {
            return new File(editor.getProject().getBasePath()).getAbsolutePath();
        }
        return null;
    }

    public static String pathToUri(@Nullable String path) {
        return path != null ? FileUtils.sanitizeURI(new File(path.replace(" ", SPACE_ENCODED)).toURI().toString()) : null;
    }

    public static String projectToUri(Project project) {
        if (project != null && project.getBasePath() != null) {
            return FileUtils.pathToUri(new File(project.getBasePath()).getAbsolutePath());
        }
        return null;
    }

    public static String documentToUri(Document document) {
        return FileUtils.sanitizeURI(FileUtils.VFSToURI(FileDocumentManager.getInstance().getFile(document)));
    }

    public static boolean isFileSupported(@Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        if (file instanceof LightVirtualFileBase) {
            return false;
        }
        if (file.getUrl().isEmpty() || file.getUrl().startsWith("jar:")) {
            return false;
        }
        return IntellijLanguageClient.isExtensionSupported(file);
    }

    public static boolean isEditorSupported(@NotNull Editor editor) {
        if (editor == null) {
            FileUtils.$$$reportNull$$$0(0);
        }
        return FileUtils.isFileSupported(FileDocumentManager.getInstance().getFile(editor.getDocument()));
    }

    @NotNull
    public static Set<Project> findProjectsFor(@NotNull VirtualFile file) {
        if (file == null) {
            FileUtils.$$$reportNull$$$0(1);
        }
        Set<Project> set = Arrays.stream(ProjectManager.getInstance().getOpenProjects()).flatMap(p -> Arrays.stream(FileUtils.searchFiles(file, p))).filter(f -> f.getVirtualFile().getPath().equals(file.getPath())).map(PsiElement::getProject).collect(Collectors.toSet());
        if (set == null) {
            FileUtils.$$$reportNull$$$0(2);
        }
        return set;
    }

    private static PsiFile[] searchFiles(VirtualFile file, Project p) {
        return (PsiFile[])ApplicationUtils.computableReadAction(() -> FilenameIndex.getFilesByName((Project)p, (String)file.getName(), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)p)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/wso2/lsp4intellij/utils/FileUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/wso2/lsp4intellij/utils/FileUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "findProjectsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEditorSupported";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findProjectsFor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OS {
        WINDOWS,
        UNIX;

    }
}

