/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.DocumentUtil;
import org.eclipse.lsp4j.Position;
import org.wso2.lsp4intellij.utils.ApplicationUtils;

public class DocumentUtils {
    private static Logger LOG = Logger.getInstance(DocumentUtils.class);
    public static final String WIN_SEPARATOR = "\r\n";
    public static final String LINUX_SEPARATOR = "\n";

    public static String getLineText(Editor editor, int startOffset, int endOffset) {
        return (String)ApplicationUtils.computableReadAction(() -> {
            Document doc = editor.getDocument();
            int lineIdx = doc.getLineNumber(startOffset);
            int lineStartOff = doc.getLineStartOffset(lineIdx);
            int lineEndOff = doc.getLineEndOffset(lineIdx);
            String line = doc.getText(new TextRange(lineStartOff, lineEndOff));
            int startOffsetInLine = startOffset - lineStartOff;
            int endOffsetInLine = endOffset - lineStartOff;
            return (String)ApplicationUtils.computableReadAction(() -> line.substring(0, startOffsetInLine) + "<b>" + line.substring(startOffsetInLine, endOffsetInLine) + "</b>" + line.substring(endOffsetInLine));
        });
    }

    public static Position logicalToLSPPos(LogicalPosition position, Editor editor) {
        return DocumentUtils.offsetToLSPPos(editor, editor.logicalPositionToOffset(position));
    }

    public static Position offsetToLSPPos(LogicalPosition position, Editor editor) {
        return DocumentUtils.offsetToLSPPos(editor, editor.logicalPositionToOffset(position));
    }

    public static Position offsetToLSPPos(Editor editor, int offset) {
        return (Position)ApplicationUtils.computableReadAction(() -> {
            Document doc = editor.getDocument();
            int line = doc.getLineNumber(offset);
            int lineStart = doc.getLineStartOffset(line);
            String lineTextBeforeOffset = doc.getText(TextRange.create((int)lineStart, (int)offset));
            int column = lineTextBeforeOffset.length();
            return (Position)ApplicationUtils.computableReadAction(() -> new Position(line, column));
        });
    }

    public static int LSPPosToOffset(Editor editor, Position pos) {
        return (Integer)ApplicationUtils.computableReadAction(() -> {
            try {
                int docLength;
                Document doc = editor.getDocument();
                int line = Math.max(0, Math.min(pos.getLine(), doc.getLineCount()));
                String lineText = doc.getText(DocumentUtil.getLineTextRange((Document)doc, (int)line));
                String lineTextForPosition = !lineText.isEmpty() ? lineText.substring(0, Math.min(lineText.length(), pos.getCharacter())) : "";
                int tabs = StringUtil.countChars((CharSequence)lineTextForPosition, (char)'\t');
                int tabSize = editor.getSettings().getTabSize(editor.getProject());
                int column = tabs * tabSize + lineTextForPosition.length() - tabs;
                int offset = editor.logicalPositionToOffset(new LogicalPosition(line, column));
                if (pos.getCharacter() >= lineText.length()) {
                    LOG.warn("LSPPOS outofbounds : " + pos + " line : " + lineText + " column : " + column + " offset : " + offset);
                }
                if (offset > (docLength = doc.getTextLength())) {
                    LOG.warn("Offset greater than text length : " + offset + " > " + docLength);
                }
                return Math.min(Math.max(offset, 0), docLength);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
        });
    }
}

