/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.requests;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

public class FileEventManager {
    public static void willSave(Document doc) {
        String uri = FileUtils.VFSToURI(FileDocumentManager.getInstance().getFile(doc));
        EditorEventManager manager = EditorEventManagerBase.forUri(uri);
        if (manager != null) {
            manager.willSave();
        }
    }

    public static void willSaveAllDocuments() {
        EditorEventManagerBase.willSaveAll();
    }

    public static void fileChanged(VirtualFile file) {
        if (!FileUtils.isFileSupported(file)) {
            return;
        }
        String uri = FileUtils.VFSToURI(file);
        if (uri != null) {
            EditorEventManager manager = EditorEventManagerBase.forUri(uri);
            if (manager != null) {
                manager.documentSaved();
                FileUtils.findProjectsFor(file).forEach(p -> FileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Changed, manager.wrapper));
            } else {
                FileUtils.findProjectsFor(file).forEach(p -> FileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Changed));
            }
        }
    }

    public static void fileMoved(VirtualFile file) {
    }

    public static void fileDeleted(VirtualFile file) {
        if (!FileUtils.isFileSupported(file)) {
            return;
        }
        String uri = FileUtils.VFSToURI(file);
        if (uri != null) {
            FileUtils.findProjectsFor(file).forEach(p -> FileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Deleted));
        }
    }

    public static void fileRenamed(String oldV, String newV) {
    }

    public static void fileCreated(VirtualFile file) {
        if (!FileUtils.isFileSupported(file)) {
            return;
        }
        String uri = FileUtils.VFSToURI(file);
        if (uri != null) {
            FileUtils.findProjectsFor(file).forEach(p -> FileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Created));
        }
    }

    private static void changedConfiguration(String uri, String projectUri, FileChangeType typ) {
        FileEventManager.changedConfiguration(uri, projectUri, typ, null);
    }

    private static void changedConfiguration(String uri, String projectUri, FileChangeType typ, LanguageServerWrapper targetWrapper) {
        ApplicationUtils.pool(() -> {
            ArrayList<FileEvent> event = new ArrayList<FileEvent>();
            event.add(new FileEvent(uri, typ));
            DidChangeWatchedFilesParams params = new DidChangeWatchedFilesParams(event);
            Set<LanguageServerWrapper> wrappers = IntellijLanguageClient.getAllServerWrappers(projectUri);
            if (wrappers == null) {
                return;
            }
            for (LanguageServerWrapper wrapper : wrappers) {
                if (wrapper == targetWrapper || wrapper.getRequestManager() == null || wrapper.getStatus() != ServerStatus.INITIALIZED) continue;
                wrapper.getRequestManager().didChangeWatchedFiles(params);
            }
        });
    }
}

