/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.annotator;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.contributors.fixes.LSPCodeActionFix;
import org.wso2.lsp4intellij.contributors.fixes.LSPCommandFix;
import org.wso2.lsp4intellij.contributors.psi.LSPPsiElement;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.utils.DocumentUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

public class LSPAnnotator
extends ExternalAnnotator {
    private static final Object RESULT = new Object();

    @Nullable
    public Object collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            LSPAnnotator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LSPAnnotator.$$$reportNull$$$0(1);
        }
        try {
            VirtualFile virtualFile = file.getVirtualFile();
            if (!FileUtils.isFileSupported(virtualFile) || !IntellijLanguageClient.isExtensionSupported(virtualFile)) {
                return null;
            }
            String uri = FileUtils.VFSToURI(virtualFile);
            EditorEventManager eventManager = EditorEventManagerBase.forUri(uri);
            if (eventManager == null || eventManager.isDiagnosticsLocked()) {
                return null;
            }
            return RESULT;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public Object doAnnotate(Object collectedInfo) {
        return RESULT;
    }

    public void apply(@NotNull PsiFile file, Object annotationResult, @NotNull AnnotationHolder holder) {
        VirtualFile virtualFile;
        if (file == null) {
            LSPAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            LSPAnnotator.$$$reportNull$$$0(3);
        }
        if (FileUtils.isFileSupported(virtualFile = file.getVirtualFile()) && IntellijLanguageClient.isExtensionSupported(virtualFile)) {
            String uri = FileUtils.VFSToURI(virtualFile);
            EditorEventManager eventManager = EditorEventManagerBase.forUri(uri);
            if (eventManager == null || eventManager.isDiagnosticsLocked()) {
                return;
            }
            try {
                this.createAnnotations(file, holder, eventManager);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
        }
    }

    private void createAnnotations(PsiFile file, AnnotationHolder holder, EditorEventManager eventManager) {
        List<Diagnostic> diagnostics = eventManager.getDiagnostics();
        Editor editor = eventManager.editor;
        String uri = FileUtils.VFSToURI(file.getVirtualFile());
        diagnostics.forEach(d -> {
            Annotation annotation;
            int end;
            int start = DocumentUtils.LSPPosToOffset(editor, d.getRange().getStart());
            if (start >= (end = DocumentUtils.LSPPosToOffset(editor, d.getRange().getEnd()))) {
                return;
            }
            TextRange textRange = new TextRange(start, end);
            switch (d.getSeverity()) {
                case Error: {
                    annotation = holder.createErrorAnnotation(textRange, d.getMessage());
                    break;
                }
                case Warning: {
                    annotation = holder.createWarningAnnotation(textRange, d.getMessage());
                    break;
                }
                case Information: {
                    annotation = holder.createInfoAnnotation(textRange, d.getMessage());
                    break;
                }
                default: {
                    annotation = holder.createWeakWarningAnnotation(textRange, d.getMessage());
                }
            }
            String name = editor.getDocument().getText(textRange);
            LSPPsiElement element = new LSPPsiElement(name, editor.getProject(), start, end, file);
            List<Either<Command, CodeAction>> codeAction = eventManager.codeAction(element);
            if (codeAction != null) {
                codeAction.stream().filter(Predicates.notNull()).forEach(e -> {
                    if (e.isLeft()) {
                        annotation.registerFix((IntentionAction)new LSPCommandFix(uri, (Command)e.getLeft()), textRange);
                    } else if (e.isRight()) {
                        annotation.registerFix((IntentionAction)new LSPCodeActionFix(uri, (CodeAction)e.getRight()), textRange);
                    }
                });
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/wso2/lsp4intellij/contributors/annotator/LSPAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

