/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.utils.DocumentUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

class LSPCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(LSPCompletionContributor.class);

    public LSPCompletionContributor() {
        this.extend(CompletionType.BASIC, this.usePattern(), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (result == null) {
                    1.$$$reportNull$$$0(2);
                }
                try {
                    ApplicationUtil.runWithCheckCanceled(() -> {
                        Editor editor = parameters.getEditor();
                        int offset = parameters.getOffset();
                        Position serverPos = DocumentUtils.offsetToLSPPos(editor, offset);
                        EditorEventManager manager = EditorEventManagerBase.forEditor(editor);
                        if (manager != null) {
                            result.addAllElements(manager.completion(serverPos));
                        }
                        return null;
                    }, (ProgressIndicator)ProgressIndicatorProvider.getGlobalProgressIndicator());
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Exception e) {
                    LOG.warn("LSP Completions ended with an error", (Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "result";
                        break;
                    }
                }
                objectArray[1] = "org/wso2/lsp4intellij/contributors/LSPCompletionContributor$1";
                objectArray[2] = "addCompletions";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    protected ElementPattern<? extends PsiElement> usePattern() {
        return PlatformPatterns.not((ElementPattern)PlatformPatterns.alwaysFalse());
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        VirtualFile file;
        if (position == null) {
            LSPCompletionContributor.$$$reportNull$$$0(0);
        }
        if (!FileUtils.isFileSupported(file = position.getContainingFile().getVirtualFile())) {
            return false;
        }
        String uri = FileUtils.VFSToURI(file);
        EditorEventManager manager = EditorEventManagerBase.forUri(uri);
        if (manager == null) {
            return false;
        }
        for (String triggerChar : manager.completionTriggers) {
            if (triggerChar == null || triggerChar.length() != 1 || triggerChar.charAt(0) != typeChar) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/wso2/lsp4intellij/contributors/LSPCompletionContributor", "invokeAutoPopup"));
    }
}

