/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver.serverdefinition;

import java.util.Arrays;
import java.util.Collections;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.CommandServerDefinition;

public class ExeLanguageServerDefinition
extends CommandServerDefinition {
    private static final ExeLanguageServerDefinition INSTANCE = new ExeLanguageServerDefinition();
    private String path;
    private String[] args;

    private ExeLanguageServerDefinition() {
    }

    public static ExeLanguageServerDefinition getInstance() {
        return INSTANCE;
    }

    public ExeLanguageServerDefinition(String ext, String path, String[] args) {
        this.ext = ext;
        this.languageIds = Collections.emptyMap();
        this.path = path;
        this.args = args;
        this.command = this.getCommand();
    }

    @Override
    public String[] toArray() {
        String[] strings = new String[]{this.typ, this.ext, this.path};
        String[] merged = Arrays.copyOf(strings, strings.length + this.args.length);
        System.arraycopy(this.args, 0, merged, strings.length, this.args.length);
        return merged;
    }

    @Override
    public String toString() {
        return this.typ + " : path " + this.path + " args : " + String.join((CharSequence)" ", this.args);
    }

    public String[] getCommand() {
        String[] strings = new String[]{this.path};
        String[] merged = Arrays.copyOf(strings, strings.length + this.args.length);
        System.arraycopy(this.args, 0, merged, strings.length, this.args.length);
        return merged;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExeLanguageServerDefinition) {
            ExeLanguageServerDefinition commandsDef = (ExeLanguageServerDefinition)obj;
            return this.ext.equals(commandsDef.ext) && this.path.equals(commandsDef.path) && Arrays.equals(this.args, commandsDef.args);
        }
        return false;
    }

    public int hashCode() {
        return this.ext.hashCode() + 3 * this.path.hashCode() + 7 * this.args.hashCode();
    }
}

