/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver.serverdefinition;

import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.wso2.lsp4intellij.client.connection.ProcessStreamConnectionProvider;
import org.wso2.lsp4intellij.client.connection.StreamConnectionProvider;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.UserConfigurableServerDefinition;
import org.wso2.lsp4intellij.utils.Utils;

public class ArtifactLanguageServerDefinition
extends UserConfigurableServerDefinition {
    private static final Logger LOG = Logger.getInstance(UserConfigurableServerDefinition.class);
    private String packge;
    private String mainClass;
    private String[] args;
    private static final ArtifactLanguageServerDefinition INSTANCE = new ArtifactLanguageServerDefinition();

    private ArtifactLanguageServerDefinition() {
    }

    public static ArtifactLanguageServerDefinition getInstance() {
        return INSTANCE;
    }

    public ArtifactLanguageServerDefinition(String ext, String packge, String mainClass, String[] args) {
        this.ext = ext;
        this.languageIds = Collections.emptyMap();
        this.packge = packge;
        this.mainClass = mainClass;
        this.args = args;
        this.typ = "artifact";
        this.presentableTyp = "Artifact";
    }

    @Override
    public ArtifactLanguageServerDefinition fromArray(String[] arr) {
        if (arr[0].equals(this.typ)) {
            String[] arrTail = ArtifactLanguageServerDefinition.tail(arr);
            if (arrTail.length < 3) {
                LOG.warn("Not enough elements to translate into a ServerDefinition : " + String.join((CharSequence)" ; ", arr));
                return null;
            }
            String[] args = arrTail.length > 3 ? Utils.parseArgs(ArtifactLanguageServerDefinition.tail(ArtifactLanguageServerDefinition.tail(ArtifactLanguageServerDefinition.tail(arrTail)))) : new String[]{};
            return new ArtifactLanguageServerDefinition(arrTail[0], ArtifactLanguageServerDefinition.head(ArtifactLanguageServerDefinition.tail(arrTail)), ArtifactLanguageServerDefinition.head(ArtifactLanguageServerDefinition.tail(ArtifactLanguageServerDefinition.tail(arrTail))), args);
        }
        return null;
    }

    @Override
    public StreamConnectionProvider createConnectionProvider(String workingDir) {
        String cp = this.packge;
        ArrayList<String> command = new ArrayList<String>();
        command.add("java");
        command.add("-cp");
        command.add(cp);
        command.add(this.mainClass);
        Collections.addAll(command, this.args);
        return new ProcessStreamConnectionProvider(command, workingDir);
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getTyp() + " : " + this.packge + " mainClass : " + this.mainClass + " args : " + String.join((CharSequence)" ", this.args);
    }

    @Override
    public String[] toArray() {
        String[] strings = new String[]{this.getTyp(), this.ext, this.packge, this.mainClass};
        String[] merged = Arrays.copyOf(strings, strings.length + this.args.length);
        System.arraycopy(this.args, 0, merged, strings.length, this.args.length);
        return merged;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArtifactLanguageServerDefinition) {
            ArtifactLanguageServerDefinition definition = (ArtifactLanguageServerDefinition)obj;
            return this.ext.equals(definition.ext) && this.mainClass.equals(definition.mainClass) && Arrays.equals(this.args, definition.args);
        }
        return false;
    }

    public int hashCode() {
        return this.ext.hashCode() + 3 * this.packge.hashCode() + 7 * this.mainClass.hashCode() + 11 * this.args.hashCode();
    }
}

