/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver.requestmanager;

import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.ColorPresentation;
import org.eclipse.lsp4j.ColorPresentationParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentColorParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentLink;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticHighlightingParams;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.StaticRegistrationOptions;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.jsonrpc.messages.CancelParams;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.requestmanager.RequestManager;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;

public class DefaultRequestManager
implements RequestManager {
    private Logger LOG = Logger.getInstance(DefaultRequestManager.class);
    private LanguageServerWrapper wrapper;
    private LanguageServer server;
    private LanguageClient client;
    private ServerCapabilities serverCapabilities;
    private TextDocumentSyncOptions textDocumentOptions;
    private WorkspaceService workspaceService;
    private TextDocumentService textDocumentService;

    public DefaultRequestManager(LanguageServerWrapper wrapper, LanguageServer server, LanguageClient client, ServerCapabilities serverCapabilities) {
        this.wrapper = wrapper;
        this.server = server;
        this.client = client;
        this.serverCapabilities = serverCapabilities;
        this.textDocumentOptions = serverCapabilities.getTextDocumentSync().isRight() ? (TextDocumentSyncOptions)serverCapabilities.getTextDocumentSync().getRight() : null;
        this.workspaceService = server.getWorkspaceService();
        this.textDocumentService = server.getTextDocumentService();
    }

    public LanguageServerWrapper getWrapper() {
        return this.wrapper;
    }

    public LanguageClient getClient() {
        return this.client;
    }

    public LanguageServer getServer() {
        return this.server;
    }

    public ServerCapabilities getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public void showMessage(MessageParams messageParams) {
        this.client.showMessage(messageParams);
    }

    @Override
    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams showMessageRequestParams) {
        return this.client.showMessageRequest(showMessageRequestParams);
    }

    @Override
    public void logMessage(MessageParams messageParams) {
        this.client.logMessage(messageParams);
    }

    @Override
    public void telemetryEvent(Object o) {
        this.client.telemetryEvent(o);
    }

    @Override
    public CompletableFuture<Void> registerCapability(RegistrationParams params) {
        return this.client.registerCapability(params);
    }

    @Override
    public CompletableFuture<Void> unregisterCapability(UnregistrationParams params) {
        return this.client.unregisterCapability(params);
    }

    @Override
    public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(ApplyWorkspaceEditParams params) {
        return this.client.applyEdit(params);
    }

    @Override
    public void publishDiagnostics(PublishDiagnosticsParams publishDiagnosticsParams) {
        this.client.publishDiagnostics(publishDiagnosticsParams);
    }

    @Override
    public void semanticHighlighting(SemanticHighlightingParams params) {
        this.client.semanticHighlighting(params);
    }

    @Override
    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        if (this.checkStatus()) {
            try {
                return this.server.initialize(params);
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void initialized(InitializedParams params) {
        if (this.wrapper.getStatus() == ServerStatus.STARTED) {
            try {
                this.server.initialized(params);
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public CompletableFuture<Object> shutdown() {
        if (this.checkStatus()) {
            try {
                return this.server.shutdown();
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void exit() {
        if (this.checkStatus()) {
            try {
                this.server.exit();
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public void cancelRequest(CancelParams params) {
    }

    @Override
    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        if (this.checkStatus()) {
            try {
                this.workspaceService.didChangeConfiguration(params);
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
        if (this.checkStatus()) {
            try {
                this.workspaceService.didChangeWatchedFiles(params);
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getWorkspaceSymbolProvider() != false ? this.workspaceService.symbol(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<Object> executeCommand(ExecuteCommandParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getExecuteCommandProvider() != null ? this.workspaceService.executeCommand(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void didOpen(DidOpenTextDocumentParams params) {
        if (this.checkStatus()) {
            try {
                if (this.textDocumentOptions == null || this.textDocumentOptions.getOpenClose().booleanValue()) {
                    this.textDocumentService.didOpen(params);
                }
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public void didChange(DidChangeTextDocumentParams params) {
        if (this.checkStatus()) {
            try {
                if (this.textDocumentOptions == null || this.textDocumentOptions.getChange() != null) {
                    this.textDocumentService.didChange(params);
                }
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public void willSave(WillSaveTextDocumentParams params) {
        if (this.checkStatus()) {
            try {
                if (this.textDocumentOptions == null || this.textDocumentOptions.getWillSave().booleanValue()) {
                    this.textDocumentService.willSave(params);
                }
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public CompletableFuture<List<TextEdit>> willSaveWaitUntil(WillSaveTextDocumentParams params) {
        if (this.checkStatus()) {
            try {
                return this.textDocumentOptions == null || this.textDocumentOptions.getWillSaveWaitUntil() != false ? this.textDocumentService.willSaveWaitUntil(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public void didSave(DidSaveTextDocumentParams params) {
        if (this.checkStatus()) {
            try {
                if (this.textDocumentOptions == null || this.textDocumentOptions.getSave() != null) {
                    this.textDocumentService.didSave(params);
                }
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public void didClose(DidCloseTextDocumentParams params) {
        if (this.checkStatus()) {
            try {
                if (this.textDocumentOptions == null || this.textDocumentOptions.getOpenClose().booleanValue()) {
                    this.textDocumentService.didClose(params);
                }
            }
            catch (Exception e) {
                this.crashed(e);
            }
        }
    }

    @Override
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getCompletionProvider() != null ? this.textDocumentService.completion(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<CompletionItem> completionItemResolve(CompletionItem unresolved) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getCompletionProvider() != null && this.serverCapabilities.getCompletionProvider().getResolveProvider() != false ? this.textDocumentService.resolveCompletionItem(unresolved) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<Hover> hover(TextDocumentPositionParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getHoverProvider() != false ? this.textDocumentService.hover(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<SignatureHelp> signatureHelp(TextDocumentPositionParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getSignatureHelpProvider() != null ? this.textDocumentService.signatureHelp(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getReferencesProvider() != false ? this.textDocumentService.references(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(TextDocumentPositionParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDocumentHighlightProvider() != false ? this.textDocumentService.documentHighlight(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDocumentSymbolProvider() != false ? this.textDocumentService.documentSymbol(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDocumentFormattingProvider() != false ? this.textDocumentService.formatting(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDocumentRangeFormattingProvider() != null ? this.textDocumentService.rangeFormatting(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDocumentOnTypeFormattingProvider() != null ? this.textDocumentService.onTypeFormatting(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<? extends Location>> definition(TextDocumentPositionParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDefinitionProvider() != false ? this.textDocumentService.definition(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        if (this.checkStatus()) {
            try {
                return this.checkCodeActionProvider((Either<Boolean, CodeActionOptions>)this.serverCapabilities.getCodeActionProvider()) ? this.textDocumentService.codeAction(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getCodeLensProvider() != null ? this.textDocumentService.codeLens(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getCodeLensProvider() != null && this.serverCapabilities.getCodeLensProvider().isResolveProvider() ? this.textDocumentService.resolveCodeLens(unresolved) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<List<DocumentLink>> documentLink(DocumentLinkParams params) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDocumentLinkProvider() != null ? this.textDocumentService.documentLink(params) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<DocumentLink> documentLinkResolve(DocumentLink unresolved) {
        if (this.checkStatus()) {
            try {
                return this.serverCapabilities.getDocumentLinkProvider() != null && this.serverCapabilities.getDocumentLinkProvider().getResolveProvider() != false ? this.textDocumentService.documentLinkResolve(unresolved) : null;
            }
            catch (Exception e) {
                this.crashed(e);
                return null;
            }
        }
        return null;
    }

    @Override
    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        return null;
    }

    @Override
    public CompletableFuture<List<? extends Location>> implementation(TextDocumentPositionParams params) {
        return null;
    }

    @Override
    public CompletableFuture<List<? extends Location>> typeDefinition(TextDocumentPositionParams params) {
        return null;
    }

    @Override
    public CompletableFuture<List<ColorInformation>> documentColor(DocumentColorParams params) {
        return null;
    }

    @Override
    public CompletableFuture<List<ColorPresentation>> colorPresentation(ColorPresentationParams params) {
        return null;
    }

    @Override
    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        return null;
    }

    public boolean checkStatus() {
        return this.wrapper.getStatus() == ServerStatus.INITIALIZED;
    }

    private void crashed(Exception e) {
        this.LOG.warn((Throwable)e);
        this.wrapper.crashed(e);
    }

    private boolean checkProvider(Either<Boolean, StaticRegistrationOptions> provider) {
        return provider != null && (provider.isLeft() && (Boolean)provider.getLeft() != false || provider.isRight() && provider.getRight() != null);
    }

    private boolean checkCodeActionProvider(Either<Boolean, CodeActionOptions> provider) {
        return provider != null && (provider.isLeft() && (Boolean)provider.getLeft() != false || provider.isRight() && provider.getRight() != null);
    }
}

