/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;
import org.wso2.lsp4intellij.contributors.icon.LSPIconProvider;
import org.wso2.lsp4intellij.requests.Timeouts;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.GUIUtils;

public class LSPServerStatusWidget
implements StatusBarWidget {
    private static Map<Project, List<String>> widgetIDs = new HashMap<Project, List<String>>();
    private Map<Timeouts, Pair<Integer, Integer>> timeouts = new HashMap<Timeouts, Pair<Integer, Integer>>();
    private LanguageServerWrapper wrapper;
    private String ext;
    private Project project;
    private String projectName;
    private Map<ServerStatus, Icon> icons;
    private ServerStatus status = ServerStatus.STOPPED;

    private LSPServerStatusWidget(LanguageServerWrapper wrapper) {
        this.wrapper = wrapper;
        this.ext = wrapper.getServerDefinition().ext;
        this.project = wrapper.getProject();
        this.projectName = this.project.getName();
        GUIUtils.getIconProviderFor(wrapper.getServerDefinition());
        this.icons = LSPIconProvider.getStatusIcons();
        for (Timeouts t : Timeouts.values()) {
            this.timeouts.put(t, (Pair<Integer, Integer>)new MutablePair((Object)0, (Object)0));
        }
    }

    public static LSPServerStatusWidget createWidgetFor(LanguageServerWrapper wrapper) {
        LSPServerStatusWidget widget = new LSPServerStatusWidget(wrapper);
        Project project = wrapper.getProject();
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (widgetIDs.get(project) == null || widgetIDs.get(project).isEmpty()) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("Position");
            widgetIDs.put(project, list);
        }
        statusBar.addWidget((StatusBarWidget)widget, "before " + widgetIDs.get(project).get(0));
        widgetIDs.get(project).add(0, widget.ID());
        return widget;
    }

    private static void removeWidgetID(LSPServerStatusWidget widget) {
        Project project = widget.wrapper.getProject();
        widgetIDs.get(project).remove(widget.ID());
    }

    public void notifyResult(Timeouts timeout, Boolean success) {
        Pair<Integer, Integer> oldValue = this.timeouts.get((Object)timeout);
        if (success.booleanValue()) {
            this.timeouts.replace(timeout, (Pair<Integer, Integer>)new MutablePair((Object)((Integer)oldValue.getKey() + 1), oldValue.getValue()));
        } else {
            this.timeouts.replace(timeout, (Pair<Integer, Integer>)new MutablePair(oldValue.getKey(), (Object)((Integer)oldValue.getValue() + 1)));
        }
    }

    public StatusBarWidget.IconPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        if (type == null) {
            LSPServerStatusWidget.$$$reportNull$$$0(0);
        }
        return new StatusBarWidget.IconPresentation(){

            @NotNull
            public Icon getIcon() {
                Icon icon = (Icon)LSPServerStatusWidget.this.icons.get((Object)LSPServerStatusWidget.this.status);
                if (icon == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon;
            }

            @NotNull
            public Consumer<MouseEvent> getClickConsumer() {
                Consumer consumer = t -> {
                    JBPopupFactory.ActionSelectionAid mnemonics = JBPopupFactory.ActionSelectionAid.MNEMONICS;
                    Component component = t.getComponent();
                    ArrayList<AnAction> actions = new ArrayList<AnAction>();
                    if (LSPServerStatusWidget.this.wrapper.getStatus() == ServerStatus.INITIALIZED) {
                        actions.add(new ShowConnectedFiles());
                    }
                    actions.add(new ShowTimeouts());
                    if (LSPServerStatusWidget.this.wrapper.isResettable()) {
                        actions.add(new Reset());
                    }
                    String title = "Server actions";
                    DataContext context = DataManager.getInstance().getDataContext(component);
                    DefaultActionGroup group = new DefaultActionGroup(actions);
                    ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup(title, (ActionGroup)group, context, mnemonics, true);
                    Dimension dimension = popup.getContent().getPreferredSize();
                    Point at = new Point(0, -dimension.height);
                    popup.show(new RelativePoint(t.getComponent(), at));
                };
                if (consumer == null) {
                    1.$$$reportNull$$$0(1);
                }
                return consumer;
            }

            public String getTooltipText() {
                return "Language server for extension " + LSPServerStatusWidget.this.ext + ", project " + LSPServerStatusWidget.this.projectName;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "org/wso2/lsp4intellij/client/languageserver/LSPServerStatusWidget$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getClickConsumer";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }

            class Reset
            extends AnAction
            implements DumbAware {
                Reset() {
                    super("&Reset", "Reset the server so it can be started again.", null);
                }

                public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                    if (anActionEvent == null) {
                        Reset.$$$reportNull$$$0(0);
                    }
                    LSPServerStatusWidget.this.wrapper.reset();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anActionEvent", "org/wso2/lsp4intellij/client/languageserver/LSPServerStatusWidget$1$Reset", "actionPerformed"));
                }
            }

            class ShowTimeouts
            extends AnAction
            implements DumbAware {
                ShowTimeouts() {
                    super("&Show timeouts", "Show the timeouts proportions of the server", null);
                }

                public void actionPerformed(AnActionEvent e) {
                    StringBuilder message = new StringBuilder();
                    message.append("<html>");
                    message.append("Timeouts (failed requests) :<br>");
                    LSPServerStatusWidget.this.timeouts.forEach((t, v) -> {
                        int timeouts = (Integer)v.getRight();
                        message.append(t.name().substring(0, 1)).append(t.name().substring(1).toLowerCase()).append(" => ");
                        int total = (Integer)v.getLeft() + timeouts;
                        if (total != 0) {
                            if (timeouts > 0) {
                                message.append("<font color=\"red\">");
                            }
                            message.append(timeouts).append("/").append(total).append(" (").append(100.0 * (double)timeouts / (double)total).append("%)<br>");
                            if (timeouts > 0) {
                                message.append("</font>");
                            }
                        } else {
                            message.append("0/0 (0%)<br>");
                        }
                    });
                    message.append("</html>");
                    Messages.showInfoMessage((String)message.toString(), (String)"Timeouts");
                }
            }

            class ShowConnectedFiles
            extends AnAction
            implements DumbAware {
                ShowConnectedFiles() {
                    super("&Show connected files", "Show the files connected to the server", null);
                }

                public void actionPerformed(AnActionEvent e) {
                    StringBuilder connectedFiles = new StringBuilder("Connected files :");
                    LSPServerStatusWidget.this.wrapper.getConnectedFiles().forEach(f -> connectedFiles.append(System.lineSeparator()).append((String)f));
                    Messages.showInfoMessage((String)connectedFiles.toString(), (String)"Connected Files");
                }
            }
        };
    }

    public void install(@NotNull StatusBar statusBar) {
        if (statusBar == null) {
            LSPServerStatusWidget.$$$reportNull$$$0(1);
        }
    }

    public void setStatus(ServerStatus status) {
        this.status = status;
        this.updateWidget();
    }

    private void updateWidget() {
        StatusBar statusBar;
        WindowManager manager = WindowManager.getInstance();
        if (manager != null && this.project != null && !this.project.isDisposed() && (statusBar = manager.getStatusBar(this.project)) != null) {
            statusBar.updateWidget(this.ID());
        }
    }

    public void dispose() {
        WindowManager manager = WindowManager.getInstance();
        if (manager != null && this.project != null && !this.project.isDisposed()) {
            StatusBar statusBar = manager.getStatusBar(this.project);
            LSPServerStatusWidget.removeWidgetID(this);
            if (statusBar != null) {
                ApplicationUtils.invokeLater(() -> statusBar.removeWidget(this.ID()));
            }
        }
    }

    @NotNull
    public String ID() {
        String string = this.projectName + "_" + this.ext;
        if (string == null) {
            LSPServerStatusWidget.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/wso2/lsp4intellij/client/languageserver/LSPServerStatusWidget";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/wso2/lsp4intellij/client/languageserver/LSPServerStatusWidget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

