/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.Icon;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.ApplyWorkspaceEditResponse;
import org.eclipse.lsp4j.ConfigurationParams;
import org.eclipse.lsp4j.MessageActionItem;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.ShowMessageRequestParams;
import org.eclipse.lsp4j.UnregistrationParams;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.lsp4j.services.LanguageClient;
import org.wso2.lsp4intellij.client.ClientContext;
import org.wso2.lsp4intellij.client.DynamicRegistrationMethods;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.requests.WorkspaceEditHandler;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

public class DefaultLanguageClient
implements LanguageClient {
    private Logger LOG = Logger.getInstance(DefaultLanguageClient.class);
    private Map<String, DynamicRegistrationMethods> registrations = new ConcurrentHashMap<String, DynamicRegistrationMethods>();
    private ClientContext context;

    public DefaultLanguageClient(ClientContext context) {
        this.context = context;
    }

    public CompletableFuture<ApplyWorkspaceEditResponse> applyEdit(ApplyWorkspaceEditParams params) {
        boolean response = WorkspaceEditHandler.applyEdit(params.getEdit(), "LSP edits");
        return CompletableFuture.supplyAsync(() -> new ApplyWorkspaceEditResponse(response));
    }

    public CompletableFuture<List<Object>> configuration(ConfigurationParams configurationParams) {
        return super.configuration(configurationParams);
    }

    public CompletableFuture<List<WorkspaceFolder>> workspaceFolders() {
        return super.workspaceFolders();
    }

    public CompletableFuture<Void> registerCapability(RegistrationParams params) {
        return CompletableFuture.runAsync(() -> params.getRegistrations().forEach(r -> {
            String id = r.getId();
            Optional<DynamicRegistrationMethods> method = DynamicRegistrationMethods.forName(r.getMethod());
            method.ifPresent(dynamicRegistrationMethods -> this.registrations.put(id, (DynamicRegistrationMethods)((Object)((Object)((Object)dynamicRegistrationMethods)))));
        }));
    }

    public CompletableFuture<Void> unregisterCapability(UnregistrationParams params) {
        return CompletableFuture.runAsync(() -> params.getUnregisterations().forEach(r -> {
            String id = r.getId();
            Optional<DynamicRegistrationMethods> method = DynamicRegistrationMethods.forName(r.getMethod());
            if (this.registrations.containsKey(id)) {
                this.registrations.remove(id);
            } else {
                HashMap<DynamicRegistrationMethods, String> inverted = new HashMap<DynamicRegistrationMethods, String>();
                for (Map.Entry<String, DynamicRegistrationMethods> entry : this.registrations.entrySet()) {
                    inverted.put(entry.getValue(), entry.getKey());
                }
                if (method.isPresent() && inverted.containsKey((Object)method.get())) {
                    this.registrations.remove(inverted.get((Object)method.get()));
                }
            }
        }));
    }

    public void telemetryEvent(Object o) {
    }

    public void publishDiagnostics(PublishDiagnosticsParams publishDiagnosticsParams) {
        String uri = FileUtils.sanitizeURI(publishDiagnosticsParams.getUri());
        List diagnostics = publishDiagnosticsParams.getDiagnostics();
        EditorEventManager manager = EditorEventManagerBase.forUri(uri);
        if (manager != null) {
            manager.diagnostics(diagnostics);
        }
    }

    public void showMessage(MessageParams messageParams) {
        String title = "Language Server message";
        String message = messageParams.getMessage();
        ApplicationUtils.invokeLater(() -> {
            MessageType msgType = messageParams.getType();
            if (msgType == MessageType.Error) {
                Messages.showErrorDialog((String)message, (String)title);
            } else if (msgType == MessageType.Warning) {
                Messages.showErrorDialog((String)message, (String)title);
            } else if (msgType == MessageType.Info) {
                Messages.showErrorDialog((String)message, (String)title);
            } else if (msgType == MessageType.Log) {
                Messages.showErrorDialog((String)message, (String)title);
            } else {
                this.LOG.warn("No message type for " + message);
            }
        });
    }

    public CompletableFuture<MessageActionItem> showMessageRequest(ShowMessageRequestParams showMessageRequestParams) {
        Icon icon;
        List actions = showMessageRequestParams.getActions();
        String title = "Language Server message";
        String message = showMessageRequestParams.getMessage();
        MessageType msgType = showMessageRequestParams.getType();
        if (msgType == MessageType.Error) {
            icon = UIUtil.getErrorIcon();
        } else if (msgType == MessageType.Warning) {
            icon = UIUtil.getWarningIcon();
        } else if (msgType == MessageType.Info) {
            icon = UIUtil.getInformationIcon();
        } else if (msgType == MessageType.Log) {
            icon = UIUtil.getInformationIcon();
        } else {
            icon = null;
            this.LOG.warn("No message type for " + message);
        }
        ArrayList<String> titles = new ArrayList<String>();
        for (MessageActionItem item : actions) {
            titles.add(item.getTitle());
        }
        FutureTask<Integer> task = new FutureTask<Integer>(() -> Messages.showDialog((String)message, (String)title, (String[])((String[])titles.toArray()), (int)0, (Icon)icon));
        ApplicationManager.getApplication().invokeAndWait(task);
        int exitCode = 0;
        try {
            exitCode = task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            this.LOG.warn(e.getMessage());
        }
        return CompletableFuture.completedFuture(new MessageActionItem(((MessageActionItem)actions.get(exitCode)).getTitle()));
    }

    public void logMessage(MessageParams messageParams) {
        String message = messageParams.getMessage();
        MessageType msgType = messageParams.getType();
        if (msgType == MessageType.Error) {
            this.LOG.error(message);
        } else if (msgType == MessageType.Warning) {
            this.LOG.warn(message);
        } else if (msgType == MessageType.Info) {
            this.LOG.info(message);
        }
        if (msgType == MessageType.Log) {
            this.LOG.debug(message);
        } else {
            this.LOG.warn("Unknown message type for " + message);
        }
    }

    protected final ClientContext getContext() {
        return this.context;
    }
}

