/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.utils;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.Hint;
import com.intellij.ui.LightweightHint;
import java.awt.Point;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.LanguageServerDefinition;
import org.wso2.lsp4intellij.contributors.icon.LSPDefaultIconProvider;
import org.wso2.lsp4intellij.contributors.icon.LSPIconProvider;
import org.wso2.lsp4intellij.contributors.label.LSPDefaultLabelProvider;
import org.wso2.lsp4intellij.contributors.label.LSPLabelProvider;
import org.wso2.lsp4intellij.extensions.LSPExtensionManager;
import org.wso2.lsp4intellij.utils.ApplicationUtils;

public final class GUIUtils {
    private static final LSPDefaultIconProvider DEFAULT_ICON_PROVIDER = new LSPDefaultIconProvider();
    private static final LSPLabelProvider DEFAULT_LABEL_PROVIDER = new LSPDefaultLabelProvider();
    private static final Logger LOGGER = Logger.getInstance(GUIUtils.class);

    private GUIUtils() {
    }

    public static Hint createAndShowEditorHint(Editor editor, String string, Point point) {
        return GUIUtils.createAndShowEditorHint(editor, string, point, (short)1, 42);
    }

    public static Hint createAndShowEditorHint(Editor editor, String string, Point point, int flags) {
        return GUIUtils.createAndShowEditorHint(editor, string, point, (short)1, flags);
    }

    public static Hint createAndShowEditorHint(Editor editor, String string, Point point, short constraint, int flags) {
        JTextPane textPane = new JTextPane();
        textPane.setEditorKit(new HTMLEditorKit());
        textPane.setText(string);
        textPane.setEditable(false);
        textPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Objects.nonNull(e.getURL())) {
                try {
                    if ("http".equals(e.getURL().getProtocol())) {
                        BrowserLauncher.getInstance().browse(e.getURL().toURI());
                    } else {
                        Project project = editor.getProject();
                        Optional<Pair> fileToOpen = Optional.ofNullable(project).map(p -> {
                            try {
                                return Optional.ofNullable(VfsUtil.findFileByURL((URL)new URL(VfsUtilCore.fixURLforIDEA((String)e.getURL().toString())))).map(f -> new ImmutablePair(p, f));
                            }
                            catch (MalformedURLException ex) {
                                LOGGER.debug("Invalid URL was found.", (Throwable)ex);
                                return Optional.empty();
                            }
                        }).orElse(Optional.empty());
                        fileToOpen.ifPresent(f -> {
                            OpenFileDescriptor descriptor = new OpenFileDescriptor((Project)f.getLeft(), (VirtualFile)f.getRight());
                            ApplicationUtils.writeAction(() -> FileEditorManager.getInstance((Project)((Project)f.getLeft())).openTextEditor(descriptor, true));
                        });
                    }
                }
                catch (URISyntaxException ex) {
                    Messages.showErrorDialog((String)"Invalid syntax in URL", (String)"Open URL Error");
                    LOGGER.debug("Invalid URL was found.", (Throwable)ex);
                }
            }
        });
        LightweightHint hint = new LightweightHint((JComponent)textPane);
        Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)editor.xyToLogicalPosition(point), (short)constraint);
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, p, flags, 0, false, HintManagerImpl.createHintHint((Editor)editor, (Point)p, (LightweightHint)hint, (short)constraint).setContentActive(false));
        return hint;
    }

    public static LSPIconProvider getIconProviderFor(LanguageServerDefinition serverDefinition) {
        return IntellijLanguageClient.getExtensionManagerForDefinition(serverDefinition).map(LSPExtensionManager::getIconProvider).orElse(DEFAULT_ICON_PROVIDER);
    }

    public static LSPLabelProvider getLabelProviderFor(LanguageServerDefinition serverDefinition) {
        return IntellijLanguageClient.getExtensionManagerForDefinition(serverDefinition).map(LSPExtensionManager::getLabelProvider).orElse(DEFAULT_LABEL_PROVIDER);
    }
}

