/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.NoAccessDuringPsiEvents;
import com.intellij.openapi.util.Computable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ApplicationUtils {
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newSingleThreadExecutor();

    public static void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    public static void pool(Runnable runnable) {
        EXECUTOR_SERVICE.submit(runnable);
    }

    public static <T> T computableReadAction(Computable<T> computable) {
        return (T)ApplicationManager.getApplication().runReadAction(computable);
    }

    public static void writeAction(Runnable runnable) {
        ApplicationManager.getApplication().runWriteAction(runnable);
    }

    public static <T> T computableWriteAction(Computable<T> computable) {
        return (T)ApplicationManager.getApplication().runWriteAction(computable);
    }

    public static void invokeAfterPsiEvents(Runnable runnable) {
        Runnable wrapper = () -> {
            if (NoAccessDuringPsiEvents.isInsideEventProcessing()) {
                ApplicationUtils.invokeAfterPsiEvents(runnable);
            } else {
                runnable.run();
            }
        };
        ApplicationManager.getApplication().invokeLater(wrapper, value -> false);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                EXECUTOR_SERVICE.shutdownNow();
            }
        });
    }
}

