/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.requests;

import com.intellij.openapi.diagnostic.Logger;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.MarkedString;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;

public class HoverHandler {
    private Logger LOG = Logger.getInstance(HoverHandler.class);

    public static String getHoverString(@NonNull Hover hover) {
        if (hover == null || hover.getContents() == null) {
            return "";
        }
        Either hoverContents = hover.getContents();
        if (hoverContents.isLeft()) {
            List contents = (List)hoverContents.getLeft();
            if (contents != null && !contents.isEmpty()) {
                ArrayList<String> result = new ArrayList<String>();
                for (Either c : contents) {
                    String string = "";
                    if (c.isLeft() && !((String)c.getLeft()).isEmpty()) {
                        string = (String)c.getLeft();
                    } else if (c.isRight()) {
                        MarkedString markedString = (MarkedString)c.getRight();
                        string = markedString.getLanguage() != null && !markedString.getLanguage().isEmpty() ? "```" + markedString.getLanguage() + " " + markedString.getValue() + "```" : "";
                    }
                    MutableDataSet options = new MutableDataSet();
                    Parser parser = Parser.builder((DataHolder)options).build();
                    HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
                    if (string.isEmpty()) continue;
                    result.add(renderer.render((Node)parser.parse(string)));
                }
                return "<html>" + String.join((CharSequence)"\n\n", result) + "</html>";
            }
            return "";
        }
        if (hoverContents.isRight()) {
            MutableDataSet options = new MutableDataSet();
            Parser parser = Parser.builder((DataHolder)options).build();
            HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)options).build();
            String markedContent = ((MarkupContent)hoverContents.getRight()).getValue();
            return "<html>" + renderer.render((Node)parser.parse(markedContent)) + "</html>";
        }
        return "";
    }
}

