/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.listeners;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.jetbrains.annotations.NotNull;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

class LSPFileEventManager {
    private static final Logger LOG = Logger.getInstance(LSPFileEventManager.class);

    LSPFileEventManager() {
    }

    static void willSave(Document doc) {
        String uri = FileUtils.VFSToURI(FileDocumentManager.getInstance().getFile(doc));
        EditorEventManager manager = EditorEventManagerBase.forUri(uri);
        if (manager != null) {
            manager.willSave();
        }
    }

    static void willSaveAllDocuments() {
        EditorEventManagerBase.willSaveAll();
    }

    static void fileChanged(VirtualFile file) {
        if (!FileUtils.isFileSupported(file)) {
            return;
        }
        String uri = FileUtils.VFSToURI(file);
        if (uri == null) {
            return;
        }
        ApplicationUtils.invokeAfterPsiEvents(() -> {
            EditorEventManager manager = EditorEventManagerBase.forUri(uri);
            if (manager != null) {
                manager.documentSaved();
                FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Changed));
            } else {
                FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Changed));
            }
        });
    }

    static void fileMoved(VirtualFileMoveEvent event) {
        try {
            VirtualFile file = event.getFile();
            if (!FileUtils.isFileSupported(file)) {
                return;
            }
            String newFileUri = FileUtils.VFSToURI(file);
            String oldParentUri = FileUtils.VFSToURI(event.getOldParent());
            if (newFileUri == null || oldParentUri == null) {
                return;
            }
            String oldFileUri = String.format("%s/%s", oldParentUri, event.getFileName());
            ApplicationUtils.invokeAfterPsiEvents(() -> {
                FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(oldFileUri, FileUtils.projectToUri(p), FileChangeType.Deleted));
                FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(newFileUri, FileUtils.projectToUri(p), FileChangeType.Created));
                FileUtils.findProjectsFor(file).forEach(p -> {
                    Set<LanguageServerWrapper> wrappers = IntellijLanguageClient.getAllServerWrappersFor(FileUtils.projectToUri(p));
                    if (wrappers != null) {
                        wrappers.forEach(wrapper -> wrapper.disconnect(oldFileUri, FileUtils.projectToUri(p)));
                    }
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)p);
                    ApplicationUtils.invokeLater(() -> {
                        fileEditorManager.closeFile(file);
                        fileEditorManager.openFile(file, true);
                    });
                });
            });
        }
        catch (Exception e) {
            LOG.warn("LSP file move event failed due to :", (Throwable)e);
        }
    }

    static void fileDeleted(VirtualFile file) {
        if (!FileUtils.isFileSupported(file)) {
            return;
        }
        String uri = FileUtils.VFSToURI(file);
        if (uri == null) {
            return;
        }
        ApplicationUtils.invokeAfterPsiEvents(() -> FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Deleted)));
    }

    static void fileRenamed(String oldFileName, String newFileName) {
        ApplicationUtils.invokeAfterPsiEvents(() -> {
            try {
                Set files = Arrays.stream(ProjectManager.getInstance().getOpenProjects()).flatMap(p -> Arrays.stream(FileUtils.searchFiles(newFileName, p))).map(PsiFile::getVirtualFile).collect(Collectors.toSet());
                for (VirtualFile file : files) {
                    if (!FileUtils.isFileSupported(file)) continue;
                    String newFileUri = FileUtils.VFSToURI(file);
                    String oldFileUri = newFileUri.replace(file.getName(), oldFileName);
                    FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(oldFileUri, FileUtils.projectToUri(p), FileChangeType.Deleted));
                    FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(newFileUri, FileUtils.projectToUri(p), FileChangeType.Created));
                    FileUtils.findProjectsFor(file).forEach(p -> {
                        Set<LanguageServerWrapper> wrappers = IntellijLanguageClient.getAllServerWrappersFor(FileUtils.projectToUri(p));
                        if (wrappers != null) {
                            wrappers.forEach(wrapper -> {
                                wrapper.getRequestManager().didChangeWatchedFiles(LSPFileEventManager.getDidChangeWatchedFilesParams(oldFileUri, FileChangeType.Deleted));
                                wrapper.getRequestManager().didChangeWatchedFiles(LSPFileEventManager.getDidChangeWatchedFilesParams(newFileUri, FileChangeType.Created));
                                wrapper.disconnect(oldFileUri, FileUtils.projectToUri(p));
                            });
                        }
                        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)p);
                        ApplicationUtils.invokeLater(() -> {
                            fileEditorManager.closeFile(file);
                            fileEditorManager.openFile(file, true);
                        });
                    });
                }
            }
            catch (Exception e) {
                LOG.warn("LSP file rename event failed due to : ", (Throwable)e);
            }
        });
    }

    static void fileCreated(VirtualFile file) {
        if (!FileUtils.isFileSupported(file)) {
            return;
        }
        String uri = FileUtils.VFSToURI(file);
        if (uri != null) {
            ApplicationUtils.invokeAfterPsiEvents(() -> FileUtils.findProjectsFor(file).forEach(p -> LSPFileEventManager.changedConfiguration(uri, FileUtils.projectToUri(p), FileChangeType.Created)));
        }
    }

    private static void changedConfiguration(String uri, String projectUri, FileChangeType typ) {
        ApplicationUtils.pool(() -> {
            DidChangeWatchedFilesParams params = LSPFileEventManager.getDidChangeWatchedFilesParams(uri, typ);
            Set<LanguageServerWrapper> wrappers = IntellijLanguageClient.getAllServerWrappersFor(projectUri);
            if (wrappers == null) {
                return;
            }
            for (LanguageServerWrapper wrapper : wrappers) {
                if (wrapper.getRequestManager() == null || wrapper.getStatus() != ServerStatus.INITIALIZED) continue;
                wrapper.getRequestManager().didChangeWatchedFiles(params);
            }
        });
    }

    @NotNull
    private static DidChangeWatchedFilesParams getDidChangeWatchedFilesParams(String fileUri, FileChangeType typ) {
        ArrayList<FileEvent> event = new ArrayList<FileEvent>();
        event.add(new FileEvent(fileUri, typ));
        DidChangeWatchedFilesParams didChangeWatchedFilesParams = new DidChangeWatchedFilesParams(event);
        if (didChangeWatchedFilesParams == null) {
            LSPFileEventManager.$$$reportNull$$$0(0);
        }
        return didChangeWatchedFilesParams;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/wso2/lsp4intellij/listeners/LSPFileEventManager", "getDidChangeWatchedFilesParams"));
    }
}

