/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.listeners;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.wso2.lsp4intellij.listeners.LSPListener;

public class LSPCaretListenerImpl
extends LSPListener
implements CaretListener {
    private Logger LOG = Logger.getInstance(LSPCaretListenerImpl.class);
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> scheduledFuture = null;
    private static final long DEBOUNCE_INTERVAL_MS = 500L;

    public void caretPositionChanged(CaretEvent e) {
        try {
            if (this.scheduledFuture != null && !this.scheduledFuture.isCancelled()) {
                this.scheduledFuture.cancel(false);
            }
            this.scheduledFuture = this.scheduler.schedule(this::debouncedCaretPositionChanged, 500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception err) {
            this.LOG.warn("Error occurred when trying to update code actions", (Throwable)err);
        }
    }

    private void debouncedCaretPositionChanged() {
        if (this.checkEnabled()) {
            this.manager.requestAndShowCodeActions();
        }
    }
}

