/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.editor;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import java.awt.KeyboardFocusManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.wso2.lsp4intellij.editor.CtrlRangeMarker;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.utils.OSUtils;

public class EditorEventManagerBase {
    protected static int HOVER_TIME_THRES = EditorSettingsExternalizable.getInstance().getQuickDocOnMouseOverElementDelayMillis() * 1000000;
    protected static long SCHEDULE_THRES = 10000000L;
    protected static long POPUP_THRES = HOVER_TIME_THRES / 1000000 + 20;
    protected static long CTRL_THRES = 500000000L;
    public static Map<String, EditorEventManager> uriToManager = new ConcurrentHashMap<String, EditorEventManager>();
    public static Map<Editor, EditorEventManager> editorToManager = new ConcurrentHashMap<Editor, EditorEventManager>();
    private static int CTRL_KEY_CODE = OSUtils.isMac() ? 157 : 17;
    private static volatile boolean isKeyPressed = false;
    private static volatile boolean isCtrlDown = false;
    private static volatile CtrlRangeMarker ctrlRange;

    static synchronized CtrlRangeMarker getCtrlRange() {
        return ctrlRange;
    }

    static synchronized void setCtrlRange(CtrlRangeMarker ctrlRange) {
        EditorEventManagerBase.ctrlRange = ctrlRange;
    }

    static synchronized boolean getIsCtrlDown() {
        return isCtrlDown;
    }

    static synchronized void setIsCtrlDown(boolean isCtrlDown) {
        EditorEventManagerBase.isCtrlDown = isCtrlDown;
    }

    static synchronized boolean getIsKeyPressed() {
        return isKeyPressed;
    }

    static synchronized void setIsKeyPressed(boolean isKeyPressed) {
        EditorEventManagerBase.isKeyPressed = isKeyPressed;
    }

    public static EditorEventManager forUri(String uri) {
        EditorEventManagerBase.prune();
        return uri == null ? null : uriToManager.get(uri);
    }

    private static void prune() {
        editorToManager.forEach((key, value) -> {
            if (!value.wrapper.isActive()) {
                editorToManager.remove(key);
            }
        });
        uriToManager.forEach((key, value) -> {
            if (!value.wrapper.isActive()) {
                editorToManager.remove(key);
            }
        });
    }

    public static EditorEventManager forEditor(Editor editor) {
        EditorEventManagerBase.prune();
        return editorToManager.get(editor);
    }

    public static void willSaveAll() {
        EditorEventManagerBase.prune();
        editorToManager.forEach((key, value) -> value.willSave());
    }

    static {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(e -> {
            int eventId = e.getID();
            if (eventId == 401) {
                EditorEventManagerBase.setIsKeyPressed(true);
                if (e.getKeyCode() == CTRL_KEY_CODE) {
                    EditorEventManagerBase.setIsCtrlDown(true);
                }
            } else if (eventId == 402) {
                EditorEventManagerBase.setIsKeyPressed(false);
                if (e.getKeyCode() == CTRL_KEY_CODE) {
                    EditorEventManagerBase.setIsCtrlDown(false);
                    if (EditorEventManagerBase.getCtrlRange() != null) {
                        EditorEventManagerBase.getCtrlRange().dispose();
                        EditorEventManagerBase.setCtrlRange(null);
                    }
                }
            }
            return false;
        });
    }
}

